/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.rpc;

import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcService.class);
    private String serviceName;
    private Class<?> serviceClass;
    private Object serviceObj;
    private ServiceConfig serviceConfig;
    private Map<String, Method> methodMap;

    public RpcService(Class<?> serviceClass, Object serviceObj) {
        this.serviceClass = serviceClass;
        this.serviceObj = serviceObj;
        ServiceConfig config = new ServiceConfig();
        config.setFilters("servercontext,generic,servermonitor");
        this.serviceConfig = config;
        this.methodMap = new ConcurrentHashMap<String, Method>();
        this.cacheMethod();
    }

    public RpcService(Class<?> serviceClass, Object serviceObj, ServiceConfig serviceConfig) {
        this.serviceClass = serviceClass;
        this.serviceObj = serviceObj;
        this.serviceConfig = serviceConfig;
        this.methodMap = new ConcurrentHashMap<String, Method>();
        this.cacheMethod();
    }

    public String getServiceName() {
        if (!StringUtils.isBlank(this.serviceName)) {
            return this.serviceName;
        }
        this.serviceName = this.serviceConfig.serviceName(this.serviceClass);
        return this.serviceName;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public Object getServiceObject() {
        return this.serviceObj;
    }

    public Method getMethod(String methodName) {
        return this.methodMap.get(methodName);
    }

    public ServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public void setServiceConfig(ServiceConfig serviceConfig) {
        this.serviceConfig = serviceConfig;
    }

    private void cacheMethod() {
        Method[] methods;
        for (Method method : methods = this.serviceClass.getMethods()) {
            if (this.isObjectNativeMethod(method)) continue;
            if (this.methodMap.get(method.getName()) != null) {
                throw new IllegalArgumentException("Starlight not support method overloading, {" + method.getName() + "}");
            }
            this.methodMap.put(method.getName(), method);
            LOGGER.debug("Cache RpcService {}, method {}", (Object)this.getServiceName(), (Object)method.getName());
        }
    }

    private boolean isObjectNativeMethod(Method method) {
        return method.getDeclaringClass() == Object.class;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RpcService{");
        sb.append("serviceName='").append(this.serviceName).append('\'');
        sb.append(", serviceClass=").append(this.serviceClass);
        sb.append(", serviceObj=").append(this.serviceObj);
        sb.append(", serviceConfig=").append(this.serviceConfig);
        sb.append('}');
        return sb.toString();
    }
}

