/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.transport;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.RpcResponse;
import com.baidu.cloud.starlight.api.model.ShuttingDownEvent;

public interface GracefullyShutdown {
    public void gracefullyShutdown(long var1, long var3);

    default public RpcResponse shuttingDownEvent(String protocol) {
        RpcResponse shutdownEvent = new RpcResponse(0L);
        shutdownEvent.setResult(new ShuttingDownEvent(System.currentTimeMillis()));
        shutdownEvent.setStatus(Constants.SUCCESS_CODE);
        shutdownEvent.setProtocolName(protocol);
        shutdownEvent.setReturnType(ShuttingDownEvent.class);
        return shutdownEvent;
    }

    default public RpcResponse shuttingDownResponse(Request request) {
        RpcResponse response = new RpcResponse(request.getId());
        response.setRequest(request);
        response.setProtocolName(request.getProtocolName());
        response.setStatus(TransportException.SHUTTING_DOWN);
        response.setErrorMsg("The request will not be execute because it is shutting down");
        return response;
    }
}

