/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.utils;

import com.baidu.cloud.starlight.api.utils.StringUtils;

public class EnvUtils {
    public static int getCpuCores() {
        int cpuCores = Runtime.getRuntime().availableProcessors();
        if (EnvUtils.isJarvisEnv() && StringUtils.isNumeric(System.getenv("EM_CPU_CORES"))) {
            cpuCores = Integer.parseInt(System.getenv("EM_CPU_CORES")) / 10 * 4;
        }
        cpuCores = Math.max(8, cpuCores);
        return cpuCores;
    }

    public static int getContainerThreadNum(int defaultValue) {
        if (EnvUtils.isJarvisEnv() && EnvUtils.hasThreadEnvVar()) {
            String threadNumber = System.getenv("EM_THREAD_NUMBER");
            return Integer.parseInt(threadNumber.trim()) * 10 / 6;
        }
        return defaultValue;
    }

    public static boolean isJarvisEnv() {
        String emProductLine = System.getenv("EM_PRODUCT_LINE");
        String emPlatform = System.getenv("EM_PLATFORM");
        String emApp = System.getenv("EM_APP");
        return !StringUtils.isEmpty(emProductLine) && !StringUtils.isEmpty(emPlatform) && !StringUtils.isEmpty(emApp);
    }

    public static boolean hasThreadEnvVar() {
        String threadNum = System.getenv("EM_THREAD_NUMBER");
        return !StringUtils.isEmpty(threadNum);
    }

    public static boolean isJarvisOnline() {
        if (!EnvUtils.isJarvisEnv()) {
            return false;
        }
        String emEnvType = System.getenv("EM_ENV_TYPE");
        return "ONLINE".equalsIgnoreCase(emEnvType);
    }
}

