/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.api.utils;

import com.baidu.cloud.starlight.api.utils.NetUriUtils;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IDGenerator.class);
    private static final long START_STMP = 1627637626000L;
    private static final long SEQUENCE_BIT = 10L;
    private static final long MACHINE_BIT = 16L;
    private static final long DATACENTER_BIT = 2L;
    private static final long MAX_DATACENTER_NUM = 3L;
    private static final long MAX_MACHINE_NUM = 65535L;
    private static final long MAX_SEQUENCE = 1023L;
    private static final long MACHINE_LEFT = 10L;
    private static final long DATACENTER_LEFT = 26L;
    private static final long TIMESTMP_LEFT = 28L;
    private long dataCenterId;
    private long machineId;
    private long sequence = 0L;
    private long lastStamp = -1L;
    private static IDGenerator idGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDGenerator getInstance() {
        if (idGenerator != null) return idGenerator;
        Class<IDGenerator> clazz = IDGenerator.class;
        synchronized (IDGenerator.class) {
            if (idGenerator != null) return idGenerator;
            Random rd = new Random();
            long workerId = rd.nextInt(65536);
            long dataCenterId = rd.nextInt(3);
            try {
                String ip = NetUriUtils.getLocalHost();
                if (ip != null) {
                    workerId = Long.parseLong(ip.replaceAll("\\.", ""));
                    workerId &= 0xFFFFL;
                }
            }
            catch (Throwable e) {
                LOGGER.warn("Generate workerId from ip failed, caused by ", e);
            }
            idGenerator = new IDGenerator(dataCenterId, workerId);
            // ** MonitorExit[var0] (shouldn't be in output)
            return idGenerator;
        }
    }

    private IDGenerator(long datacenterId, long machineId) {
        if (datacenterId > 3L || datacenterId < 0L) {
            throw new IllegalArgumentException("datacenterId can't be greater than MAX_DATACENTER_NUM or less than 0");
        }
        if (machineId > 65535L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.dataCenterId = datacenterId;
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long currStmp = this.getNewstamp();
        if (currStmp < this.lastStamp) {
            throw new RuntimeException("Clock moved backwards. Refusing to generate id");
        }
        if (currStmp == this.lastStamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStamp = currStmp;
        return currStmp - 1627637626000L << 28 | this.dataCenterId << 26 | this.machineId << 10 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewstamp();
        while (mill <= this.lastStamp) {
            mill = this.getNewstamp();
        }
        return mill;
    }

    private long getNewstamp() {
        return System.currentTimeMillis();
    }
}

