/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.filter;

import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.filter.Filter;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.rpc.ClientInvoker;
import com.baidu.cloud.starlight.api.rpc.Invoker;
import com.baidu.cloud.starlight.api.rpc.RpcContext;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.utils.IdUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientContextFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientContextFilter.class);

    @Override
    public void filterRequest(Invoker invoker, Request request, RpcCallback callback) {
        try {
            if (invoker instanceof ClientInvoker) {
                ClientInvoker clientInvoker = (ClientInvoker)invoker;
                URI uRI = clientInvoker.getClientPeer().getUri();
                RpcContext.getContext().setRemoteAddress(uRI.getHost(), uRI.getPort());
            }
            if (RpcContext.getContext().getSessionID() == null) {
                RpcContext.getContext().setSessionID(IdUtils.genUUID());
            }
            if (RpcContext.getContext().getRequestID() == null) {
                RpcContext.getContext().setRequestID(String.valueOf(request.getId()));
            }
            if (RpcContext.getContext().get().size() > 0) {
                for (Map.Entry entry : RpcContext.getContext().get().entrySet()) {
                    if (((String)entry.getKey()).equalsIgnoreCase("http_servlet_request") || ((String)entry.getKey()).equalsIgnoreCase("http_servlet_response")) continue;
                    request.getAttachmentKv().putIfAbsent((String)entry.getKey(), entry.getValue());
                }
            }
            request.getNoneAdditionKv().put("rpc_context", RpcContext.getContext());
            LOGGER.debug("Client RpcContext values in thread {} is {}", (Object)Thread.currentThread().getName(), RpcContext.getContext().get());
        }
        catch (Throwable e) {
            LOGGER.warn("Set RpcContext to Request Attachment failed, {}", (Object)e.getMessage());
        }
        invoker.invoke(request, callback);
    }

    @Override
    public void filterResponse(Response response, Request request) {
        Object contextObj = request.getNoneAdditionKv().get("rpc_context");
        if (contextObj instanceof RpcContext) {
            RpcContext rpcContext = (RpcContext)contextObj;
            rpcContext.remove("rds_route_tag");
        }
    }
}

