/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.filter;

import com.baidu.cloud.starlight.api.filter.Filter;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.rpc.Invoker;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.utils.LogUtils;
import com.baidu.cloud.starlight.core.statistics.StarlightStatistics;
import com.baidu.cloud.starlight.core.statistics.StarlightStatsManager;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMonitorFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientMonitorFilter.class);

    @Override
    public void filterRequest(Invoker invoker, Request request, RpcCallback callback) {
        try {
            Map<String, String> traceSpanId = LogUtils.parseTraceIdSpanId(request);
            request.getAttachmentKv().put("trace.id", traceSpanId.get("tcid"));
            request.getAttachmentKv().put("span.id", traceSpanId.get("spid"));
            request.getAttachmentKv().put("X-B3-TraceId", traceSpanId.get("tcid"));
            request.getAttachmentKv().put("X-B3-SpanId", traceSpanId.get("spid"));
            if (request.getAttachmentKv().get("stargate.sid") == null) {
                request.getAttachmentKv().put("stargate.sid", traceSpanId.get("tcid"));
            }
            request.getAttachmentKv().computeIfAbsent("stargate.rid", k -> String.valueOf(request.getId()));
            LogUtils.addLogTimeAttachment(request, "before_client_request_time", System.currentTimeMillis());
        }
        catch (Throwable e) {
            LOGGER.warn("ClientMonitorFilter filterRequest failed, cause by ", e);
        }
        invoker.invoke(request, callback);
    }

    @Override
    public void filterResponse(Response response, Request request) {
        try {
            Object beforeRequestTime = request.getNoneAdditionKv().get("before_client_request_time");
            if (!(beforeRequestTime instanceof Long)) {
                LOGGER.warn("Exception occur when record reqlog, msg: BEFORE_CLIENT_REQUEST_TIME_KEY is null in request logkv");
            } else {
                LogUtils.addLogTimeAttachment(request, "client_request_cost", System.currentTimeMillis() - (Long)beforeRequestTime);
                LogUtils.recordRequestLog(request, response);
            }
            this.recordStats(request, response);
        }
        catch (Throwable ignore) {
            LOGGER.warn("ClientMonitorFilter filterResponse failed, cause by ", ignore);
        }
    }

    private void recordStats(Request request, Response response) {
        if (request.getRemoteURI() != null && StarlightStatsManager.getStats(request.getRemoteURI()) != null) {
            LOGGER.debug("ClientMonitorFilter start record stats");
            long startTime = System.currentTimeMillis();
            StarlightStatistics statistics = StarlightStatsManager.getStats(request.getRemoteURI());
            statistics.record(request, response);
            long recordStatsCost = System.currentTimeMillis() - startTime;
            LOGGER.debug("ClientMonitorFilter record stats cost {}", (Object)recordStatsCost);
            if (recordStatsCost > 3L) {
                LOGGER.info("ClientMonitorFilter record stats cost {}", (Object)recordStatsCost);
            }
        }
    }
}

