/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.filter;

import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.filter.Filter;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.rpc.ClientInvoker;
import com.baidu.cloud.starlight.api.rpc.RpcService;
import com.baidu.cloud.starlight.api.rpc.ServiceInvoker;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.transport.ClientPeer;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.core.rpc.callback.FilterCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FilterChain {
    public static ClientInvoker buildClientChainInvoker(final ClientInvoker clientInvoker, String filterNames) {
        List<Filter> filters = FilterChain.getFilters(filterNames);
        if (filters == null || filters.size() == 0) {
            return clientInvoker;
        }
        ClientInvoker resultInvoker = clientInvoker;
        Collections.reverse(filters);
        for (final Filter filter : filters) {
            final ClientInvoker next = resultInvoker;
            resultInvoker = new ClientInvoker(){

                @Override
                public ClientPeer getClientPeer() {
                    return clientInvoker.getClientPeer();
                }

                @Override
                public ServiceConfig getServiceConfig() {
                    return clientInvoker.getServiceConfig();
                }

                @Override
                public void invoke(Request request, RpcCallback callback) {
                    filter.filterRequest(next, request, new FilterCallback(callback, filter, request));
                }

                @Override
                public void init() {
                }

                @Override
                public void destroy() {
                    clientInvoker.destroy();
                }
            };
        }
        return resultInvoker;
    }

    public static ServiceInvoker buildServerChainInvoker(final ServiceInvoker serverInvoker, String filterNames) {
        List<Filter> filters = FilterChain.getFilters(filterNames);
        if (filters == null || filters.size() == 0) {
            return serverInvoker;
        }
        ServiceInvoker resultInvoker = serverInvoker;
        Collections.reverse(filters);
        for (final Filter filter : filters) {
            final ServiceInvoker next = resultInvoker;
            resultInvoker = new ServiceInvoker(){

                @Override
                public RpcService getRpcService() {
                    return serverInvoker.getRpcService();
                }

                @Override
                public void invoke(Request request, RpcCallback callback) {
                    filter.filterRequest(next, request, new FilterCallback(callback, filter, request));
                }

                @Override
                public void init() {
                }

                @Override
                public void destroy() {
                    serverInvoker.destroy();
                }
            };
        }
        return resultInvoker;
    }

    private static List<Filter> getFilters(String filterNames) {
        String[] filterNameList;
        if (StringUtils.isBlank(filterNames)) {
            return null;
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (String filterName : filterNameList = filterNames.split(",")) {
            if (StringUtils.isBlank(filterName)) continue;
            filters.add(ExtensionLoader.getInstance(Filter.class).getExtension(filterName.trim()));
        }
        return filters;
    }
}

