/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.filter;

import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.filter.Filter;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.rpc.Invoker;
import com.baidu.cloud.starlight.api.rpc.RpcContext;
import com.baidu.cloud.starlight.api.rpc.ServiceInvoker;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.utils.GenericUtil;
import com.baidu.cloud.starlight.core.rpc.RpcServiceRegistry;
import com.baidu.cloud.starlight.core.utils.PojoJsonUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class GenericFilter
implements Filter {
    @Override
    public void filterRequest(Invoker invoker, Request request, RpcCallback callback) {
        if (GenericUtil.isGenericCall(request) && request.getParams() != null && request.getParams().length == 2) {
            GenericUtil.markGeneric(request);
            Object[] params = request.getParams();
            String methodName = ((String)params[0]).trim();
            request.setMethodName(methodName);
            Object[] args = (Object[])params[1];
            ServiceInvoker serviceInvoker = RpcServiceRegistry.getInstance().discover(request.getServiceName());
            if (serviceInvoker == null) {
                callback.onError(new StarlightRpcException(StarlightRpcException.SERVICE_NOT_FOUND_EXCEPTION, "Service {" + request.getServiceName() + "} not found in provider"));
                return;
            }
            Method method = serviceInvoker.getRpcService().getMethod(methodName);
            if (method == null) {
                callback.onError(new StarlightRpcException(StarlightRpcException.METHOD_NOT_FOUND_EXCEPTION, "The called method {" + request.getMethodName() + "} does not exist"));
                return;
            }
            Type[] paramTypes = method.getGenericParameterTypes();
            try {
                args = PojoJsonUtils.realize(args, paramTypes);
            }
            catch (Exception e) {
                callback.onError(new StarlightRpcException(StarlightRpcException.BAD_REQUEST, "Generic request exception, convert generic args to real args failed, error: " + e.getMessage()));
                return;
            }
            request.setParams(args);
        } else {
            RpcContext.getContext().remove("is_generic");
            if (request.getAttachmentKv() != null) {
                request.getAttachmentKv().remove("is_generic");
            }
        }
        invoker.invoke(request, callback);
    }

    @Override
    public void filterResponse(Response response, Request request) {
        try {
            if (request.getAttachmentKv() != null && request.getAttachmentKv().get("is_generic") != null && ((Boolean)request.getAttachmentKv().get("is_generic")).booleanValue()) {
                GenericUtil.markGeneric(response);
                Object result = response.getResult();
                response.setResult(PojoJsonUtils.generalize(result));
            }
        }
        catch (Exception e) {
            response.setResult(null);
            response.setErrorMsg("Generic response exception, convert real result to generic result failed, error: " + e.getMessage());
            response.setStatus(StarlightRpcException.INTERNAL_SERVER_ERROR);
        }
    }
}

