/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.rpc;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.heartbeat.HeartbeatService;
import com.baidu.cloud.starlight.api.heartbeat.HeartbeatServiceImpl;
import com.baidu.cloud.starlight.api.rpc.RpcService;
import com.baidu.cloud.starlight.api.rpc.ServiceInvoker;
import com.baidu.cloud.starlight.api.rpc.StarlightServer;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.rpc.config.TransportConfig;
import com.baidu.cloud.starlight.api.rpc.threadpool.ThreadPoolFactory;
import com.baidu.cloud.starlight.api.transport.ServerPeer;
import com.baidu.cloud.starlight.api.utils.EnvUtils;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.core.filter.FilterChain;
import com.baidu.cloud.starlight.core.rpc.RpcServiceInvoker;
import com.baidu.cloud.starlight.core.rpc.RpcServiceRegistry;
import com.baidu.cloud.starlight.core.rpc.ServerProcessor;
import com.baidu.cloud.starlight.protocol.http.springrest.SpringRestHandlerMapping;
import com.baidu.cloud.starlight.transport.StarlightTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStarlightServer
implements StarlightServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStarlightServer.class);
    private ServerPeer serverPeer;
    private URI uri;

    public DefaultStarlightServer(String protocol, String host, Integer port, TransportConfig transportConfig) {
        this.uri = StringUtils.isBlank(protocol) ? this.assembleUri(null, host, port, transportConfig) : this.assembleUri(protocol, host, port, transportConfig);
        StarlightTransportFactory transportFactory = new StarlightTransportFactory();
        this.serverPeer = transportFactory.server(this.uri);
    }

    public DefaultStarlightServer(String host, Integer port, TransportConfig transportConfig) {
        this.uri = this.assembleUri(null, host, port, transportConfig);
        StarlightTransportFactory transportFactory = new StarlightTransportFactory();
        this.serverPeer = transportFactory.server(this.uri);
    }

    @Override
    public void init() {
        String bizThreadPoolName = this.uri.getParameter("biz_thread_pool_name");
        ThreadPoolFactory threadPoolFactory = ExtensionLoader.getInstance(ThreadPoolFactory.class).getExtension(bizThreadPoolName);
        threadPoolFactory.initDefaultThreadPool(this.uri, "star-s-biz");
        ServerProcessor processor = new ServerProcessor(RpcServiceRegistry.getInstance(), threadPoolFactory);
        this.serverPeer.init();
        this.serverPeer.setProcessor(processor);
        ServiceConfig serviceConfig = new ServiceConfig();
        serviceConfig.setFilters("");
        this.export(HeartbeatService.class, new HeartbeatServiceImpl(), serviceConfig);
    }

    @Override
    public void destroy() {
        boolean gracefullyShutdown = this.uri.getParameter("gracefully_shutdown", Constants.GRACEFULLY_SHUTDOWN_ENABLE);
        if (this.serverPeer != null) {
            if (gracefullyShutdown) {
                int quietPeriod = this.uri.getParameter("gracefully_shutdown_quiet_time", Constants.GRACEFULLY_SHUTDOWN_QUIET_PERIOD_VALUE);
                int timeout = this.uri.getParameter("gracefully_shutdown_timeout", Constants.GRACEFULLY_SHUTDOWN_TIMEOUT_VALUE);
                this.serverPeer.gracefullyShutdown(quietPeriod, timeout);
            } else {
                this.serverPeer.close();
            }
        }
        RpcServiceRegistry serviceRegistry = RpcServiceRegistry.getInstance();
        serviceRegistry.destroy();
    }

    @Override
    public void serve() {
        this.serverPeer.bind();
    }

    @Override
    public void export(Class<?> rpcInterface, Object rpcObject) {
        RpcService rpcService = new RpcService(rpcInterface, rpcObject);
        this.export(rpcService);
    }

    @Override
    public void export(Class<?> rpcInterface, Object rpcObject, ServiceConfig serviceConfig) {
        RpcService rpcService = new RpcService(rpcInterface, rpcObject, serviceConfig);
        this.export(rpcService);
    }

    @Override
    public void export(RpcService rpcService) {
        RpcServiceRegistry serviceRegistry = RpcServiceRegistry.getInstance();
        String filterNames = "servercontext,generic,servermonitor";
        ServiceConfig serviceConfig = rpcService.getServiceConfig();
        if (serviceConfig != null) {
            filterNames = serviceConfig.getFilters() == null ? filterNames : serviceConfig.getFilters();
        }
        ServiceInvoker serviceInvoker = FilterChain.buildServerChainInvoker(new RpcServiceInvoker(rpcService), filterNames);
        serviceRegistry.register(serviceInvoker);
        SpringRestHandlerMapping handlerMapping = SpringRestHandlerMapping.getInstance();
        handlerMapping.createMapping(rpcService.getServiceClass(), rpcService.getServiceObject());
        LOGGER.info("Export RpcService success, RpcService: {}", (Object)rpcService);
    }

    @Override
    public void unexport(Class<?> rpcInterface) {
        RpcServiceRegistry serviceRegistry = RpcServiceRegistry.getInstance();
        ServiceInvoker serviceInvoker = serviceRegistry.discover(rpcInterface.getName());
        if (serviceInvoker == null) {
            return;
        }
        this.unexport(serviceInvoker.getRpcService());
    }

    @Override
    public void unexport(RpcService rpcService) {
        RpcServiceRegistry serviceRegistry = RpcServiceRegistry.getInstance();
        serviceRegistry.unRegister(serviceRegistry.discover(rpcService.getServiceName()));
    }

    private URI assembleUri(String protocol, String host, Integer port, TransportConfig config) {
        if (StringUtils.isBlank(host)) {
            host = "0.0.0.0";
        }
        URI.Builder uriBuilder = new URI.Builder("unspecified", host, port);
        if (!StringUtils.isBlank(protocol)) {
            uriBuilder = new URI.Builder(protocol, host, port);
        }
        uriBuilder.param("connect_timeout", config.getConnectTimeoutMills() == null ? Constants.CONNECT_TIMEOUT_VALUE : config.getConnectTimeoutMills());
        uriBuilder.param("write_timeout", config.getWriteTimeoutMills() == null ? Constants.WRITE_TIMEOUT_VALUE : config.getWriteTimeoutMills());
        uriBuilder.param("all_idle_timeout", config.getAllIdleTimeout() == null ? 210 : config.getAllIdleTimeout());
        uriBuilder.param("io_thread_num", config.getIoThreadNum() == null ? Constants.DEFAULT_IO_THREADS_VALUE : config.getIoThreadNum());
        uriBuilder.param("accept_thread_num", config.getAcceptThreadNum() == null ? Constants.DEFAULT_ACCEPTOR_THREAD_VALUE : config.getAcceptThreadNum());
        uriBuilder.param("gracefully_shutdown", config.getGracefullyShutdown() == null ? Constants.GRACEFULLY_SHUTDOWN_ENABLE : config.getGracefullyShutdown());
        uriBuilder.param("gracefully_shutdown_quiet_time", config.getGracefullyQuietPeriod() == null ? Constants.GRACEFULLY_SHUTDOWN_QUIET_PERIOD_VALUE : config.getGracefullyQuietPeriod());
        uriBuilder.param("gracefully_shutdown_timeout", config.getGracefullyTimeout() == null ? Constants.GRACEFULLY_SHUTDOWN_TIMEOUT_VALUE : config.getGracefullyTimeout());
        uriBuilder.param("connect_keepalive_enabled", config.getConnectKeepAliveEnable() == null ? false : config.getConnectKeepAliveEnable());
        uriBuilder.param("max_biz_work_num", config.getBizWorkThreadNum() == null ? this.maxBizThreadNum() : config.getBizWorkThreadNum().intValue());
        uriBuilder.param("netty_ioratio", config.getIoRatio() == null ? 100 : config.getIoRatio());
        uriBuilder.param("biz_thread_pool_name", StringUtils.isEmpty(config.getBizThreadPoolName()) ? "rpc" : config.getBizThreadPoolName());
        return uriBuilder.build();
    }

    private int maxBizThreadNum() {
        int maxBizWorkerNum = EnvUtils.getContainerThreadNum(Constants.DEFAULT_MAX_BIZ_THREAD_POOL_SIZE);
        return maxBizWorkerNum;
    }
}

