/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.rpc;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.rpc.ClientInvoker;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.rpc.config.ServiceConfig;
import com.baidu.cloud.starlight.api.transport.ClientPeer;
import com.baidu.cloud.starlight.api.utils.IDGenerator;
import com.baidu.cloud.starlight.api.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientInvoker
implements ClientInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcClientInvoker.class);
    private final ClientPeer clientPeer;
    private final ServiceConfig serviceConfig;

    public RpcClientInvoker(ClientPeer clientPeer, ServiceConfig serviceConfig) {
        this.clientPeer = clientPeer;
        this.serviceConfig = serviceConfig;
    }

    @Override
    public ClientPeer getClientPeer() {
        return this.clientPeer;
    }

    @Override
    public ServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    @Override
    public void invoke(Request request, RpcCallback callback) {
        String protocolName = request.getProtocolName();
        Protocol protocol = ExtensionLoader.getInstance(Protocol.class).getExtension(protocolName);
        this.changeIdForStargate(request);
        try {
            long beforeTime = System.currentTimeMillis();
            LogUtils.addLogTimeAttachment(request, "before_encode_body_time", beforeTime);
            protocol.getEncoder().encodeBody(request);
            LogUtils.addLogTimeAttachment(request, "encode_body_cost", System.currentTimeMillis() - beforeTime);
        }
        catch (CodecException e) {
            callback.onError(e);
            return;
        }
        try {
            request.getNoneAdditionKv().put("remote_address", this.clientPeer.getUri() != null ? this.clientPeer.getUri().getAddress() : null);
            request.getNoneAdditionKv().put("before_io_thread_execute_time", System.currentTimeMillis());
            this.clientPeer.request(request, callback);
        }
        catch (TransportException e) {
            callback.onError(e);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init() {
    }

    private void changeIdForStargate(Request request) {
        try {
            String protocolName = request.getProtocolName();
            if (protocolName.equals("stargate")) {
                request.setId(IDGenerator.getInstance().nextId());
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Generate stargate requestId form IDGenerator failed, caused by ", e);
        }
    }
}

