/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.rpc;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.model.RpcResponse;
import com.baidu.cloud.starlight.api.rpc.RpcService;
import com.baidu.cloud.starlight.api.rpc.ServiceInvoker;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.utils.LogUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServiceInvoker
implements ServiceInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcServiceInvoker.class);
    private RpcService rpcService;

    public RpcServiceInvoker(RpcService rpcService) {
        this.rpcService = rpcService;
    }

    @Override
    public RpcService getRpcService() {
        return this.rpcService;
    }

    @Override
    public void invoke(Request request, RpcCallback callback) {
        Method method;
        Object beforeServFilterExec = request.getNoneAdditionKv().get("before_server_filter_exec_time");
        if (beforeServFilterExec instanceof Long) {
            LogUtils.addLogTimeAttachment(request, "server_filter_exec_cost", System.currentTimeMillis() - (Long)beforeServFilterExec);
        }
        if ((method = request.getMethod()) == null && (method = this.rpcService.getMethod(request.getMethodName())) == null) {
            callback.onError(new StarlightRpcException(StarlightRpcException.METHOD_NOT_FOUND_EXCEPTION, "The called method {" + request.getMethodName() + "} does not exist"));
            return;
        }
        Object serviceObj = request.getServiceObj();
        if (serviceObj == null) {
            serviceObj = this.rpcService.getServiceObject();
        }
        RpcResponse response = new RpcResponse(request.getId());
        response.setProtocolName(request.getProtocolName());
        ((Response)response).setRequest(request);
        try {
            long beforeMethodExeTime = System.currentTimeMillis();
            LogUtils.addLogTimeAttachment(request, "before_execute_method_time", beforeMethodExeTime);
            Object result = method.invoke(serviceObj, request.getParams());
            LogUtils.addLogTimeAttachment(request, "execute_method_cost", System.currentTimeMillis() - beforeMethodExeTime);
            ((Response)response).setStatus(Constants.SUCCESS_CODE);
            ((Response)response).setResult(result);
            response.setReturnType(method.getReturnType());
            response.setGenericReturnType(method.getGenericReturnType());
            callback.onResponse(response);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to execute method " + request.getMethodName() + ", caused by ", e);
            callback.onError(this.convertThrowable(e));
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init() {
    }

    protected StarlightRpcException convertThrowable(Throwable throwable) {
        StringBuilder errMsgSb = new StringBuilder("Server failed to execute target method");
        errMsgSb.append(", cause by: ");
        if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            errMsgSb.append(throwable.getCause().getClass().getSimpleName());
        } else {
            errMsgSb.append(throwable.getClass().getSimpleName());
        }
        errMsgSb.append(", ");
        if (throwable.getCause() != null) {
            errMsgSb.append(throwable.getMessage() == null ? throwable.getCause().getMessage() : throwable.getMessage());
        } else {
            errMsgSb.append(throwable.getMessage());
        }
        return new StarlightRpcException(StarlightRpcException.BIZ_ERROR, errMsgSb.toString());
    }
}

