/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.rpc;

import com.baidu.cloud.starlight.api.exception.RpcException;
import com.baidu.cloud.starlight.api.rpc.ServiceInvoker;
import com.baidu.cloud.starlight.api.rpc.ServiceRegistry;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RpcServiceRegistry
implements ServiceRegistry {
    private static RpcServiceRegistry serviceRegistry;
    private final Map<String, ServiceInvoker> rpcServiceMap = new ConcurrentHashMap<String, ServiceInvoker>();
    private final Map<String, String> serviceInterfaceMap = new ConcurrentHashMap<String, String>();

    private RpcServiceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RpcServiceRegistry getInstance() {
        Class<RpcServiceRegistry> clazz = RpcServiceRegistry.class;
        synchronized (RpcServiceRegistry.class) {
            if (serviceRegistry == null) {
                serviceRegistry = new RpcServiceRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return serviceRegistry;
        }
    }

    @Override
    public void register(ServiceInvoker serviceInvoker) {
        String serviceClassName = serviceInvoker.getRpcService().getServiceClass().getName();
        if (this.rpcServiceMap.get(serviceClassName) != null) {
            throw new RpcException("Service repeated register, serviceClass: " + serviceClassName);
        }
        this.rpcServiceMap.put(serviceClassName, serviceInvoker);
        String serviceKey = serviceInvoker.getRpcService().getServiceName();
        if (this.serviceInterfaceMap.get(serviceKey) != null) {
            throw new RpcException("Service repeated register, serviceName: " + serviceKey);
        }
        this.serviceInterfaceMap.put(serviceKey, serviceClassName);
    }

    @Override
    public void unRegister(ServiceInvoker serviceInvoker) {
        String serviceName = serviceInvoker.getRpcService().getServiceName();
        this.serviceInterfaceMap.remove(serviceName);
        String serviceClassName = serviceInvoker.getRpcService().getServiceClass().getName();
        this.rpcServiceMap.remove(serviceClassName);
    }

    @Override
    public ServiceInvoker discover(String serviceName) {
        ServiceInvoker serviceInvoker = this.rpcServiceMap.get(serviceName);
        if (serviceInvoker != null) {
            return serviceInvoker;
        }
        String serviceClassName = this.serviceInterfaceMap.get(serviceName);
        if (StringUtils.isEmpty(serviceClassName)) {
            return null;
        }
        return this.rpcServiceMap.get(serviceClassName);
    }

    @Override
    public Set<ServiceInvoker> rpcServices() {
        HashSet<ServiceInvoker> serviceInvokers = new HashSet<ServiceInvoker>();
        serviceInvokers.addAll(this.rpcServiceMap.values());
        return serviceInvokers;
    }

    @Override
    public void destroy() {
        if (this.serviceInterfaceMap.size() > 0) {
            this.serviceInterfaceMap.clear();
        }
        if (this.rpcServiceMap.size() > 0) {
            this.rpcServiceMap.clear();
        }
    }
}

