/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.rpc.callback;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.rpc.callback.Callback;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.thirdparty.netty.util.Timeout;

public class BizWrapCallback
implements RpcCallback {
    private final Callback bizCallback;
    private final Request request;
    private Timeout timeout;

    public BizWrapCallback(Callback bizCallback, Request request) {
        this.bizCallback = bizCallback;
        this.request = request;
    }

    @Override
    public void onResponse(Response response) {
        this.cancelTimeout();
        if (Constants.SUCCESS_CODE.equals(response.getStatus())) {
            this.bizCallback.onResponse(response.getResult());
        } else {
            Throwable exception = null;
            exception = response.getException() != null ? response.getException() : new StarlightRpcException(response.getStatus(), response.getErrorMsg(), response.getException());
            this.bizCallback.onError(exception);
        }
    }

    @Override
    public void onError(Throwable e) {
        this.cancelTimeout();
        this.bizCallback.onError(e);
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void addTimeout(Timeout timeout) {
        this.timeout = timeout;
    }

    private void cancelTimeout() {
        if (this.timeout != null && !this.timeout.isCancelled()) {
            this.timeout.cancel();
        }
    }
}

