/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.rpc.callback;

import com.baidu.cloud.starlight.api.exception.RpcException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.model.ResultFuture;
import com.baidu.cloud.starlight.api.model.RpcResponse;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.thirdparty.netty.util.Timeout;

public class FutureCallback
implements RpcCallback {
    private final ResultFuture resultFuture;
    private final Request request;
    private Timeout timeout;

    public FutureCallback(ResultFuture resultFuture, Request request) {
        this.resultFuture = resultFuture;
        this.request = request;
    }

    @Override
    public void onResponse(Response response) {
        this.cancelTimeout();
        this.resultFuture.putResponse(response);
    }

    @Override
    public void onError(Throwable e) {
        this.cancelTimeout();
        RpcResponse response = new RpcResponse(this.request.getId());
        ((Response)response).setErrorMsg(e.getMessage());
        response.setProtocolName(this.request.getProtocolName());
        if (e instanceof RpcException) {
            ((Response)response).setStatus(((RpcException)e).getCode());
        }
        this.resultFuture.putResponse(response);
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void addTimeout(Timeout timeout) {
        this.timeout = timeout;
    }

    private void cancelTimeout() {
        if (this.timeout != null && !this.timeout.isCancelled()) {
            this.timeout.cancel();
        }
    }
}

