/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.statistics;

import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.core.statistics.StarlightStatistics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StarlightStatsManager {
    private static final Map<String, StarlightStatistics> STARLIGHT_STATISTICS_MAP = new ConcurrentHashMap<String, StarlightStatistics>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StarlightStatistics getOrCreateStats(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("IP:PORT is empty when used it to create StarlightStats");
        }
        String clientKey = uri.getAddress();
        if (StringUtils.isEmpty(clientKey)) {
            throw new IllegalArgumentException("IP:PORT is empty when used it to create StarlightStats");
        }
        StarlightStatistics statistics = STARLIGHT_STATISTICS_MAP.get(clientKey);
        if (statistics != null) return statistics;
        Class<StarlightStatsManager> clazz = StarlightStatsManager.class;
        synchronized (StarlightStatsManager.class) {
            statistics = STARLIGHT_STATISTICS_MAP.get(clientKey);
            if (statistics != null) return statistics;
            statistics = new StarlightStatistics();
            STARLIGHT_STATISTICS_MAP.put(clientKey, statistics);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return statistics;
        }
    }

    public static StarlightStatistics getStats(URI uri) {
        String clientKey = uri.getAddress();
        return STARLIGHT_STATISTICS_MAP.get(clientKey);
    }

    public static void removeStats(URI uri) {
        String clientKey = uri.getAddress();
        STARLIGHT_STATISTICS_MAP.remove(clientKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StarlightStatistics getOrCreateStatsByHostPort(String hostPort) {
        if (StringUtils.isEmpty(hostPort)) {
            throw new IllegalArgumentException("IP:PORT is empty when used it to create StarlightStats");
        }
        StarlightStatistics statistics = STARLIGHT_STATISTICS_MAP.get(hostPort);
        if (statistics != null) return statistics;
        Class<StarlightStatsManager> clazz = StarlightStatsManager.class;
        synchronized (StarlightStatsManager.class) {
            statistics = STARLIGHT_STATISTICS_MAP.get(hostPort);
            if (statistics != null) return statistics;
            statistics = new StarlightStatistics();
            STARLIGHT_STATISTICS_MAP.put(hostPort, statistics);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return statistics;
        }
    }

    public static StarlightStatistics getStatsByHostPort(String hostPort) {
        return STARLIGHT_STATISTICS_MAP.get(hostPort);
    }

    public static void removeStatsByHostPort(String hostPort) {
        STARLIGHT_STATISTICS_MAP.remove(hostPort);
    }
}

