/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.core.utils;

import com.baidu.cloud.thirdparty.jackson.databind.DeserializationFeature;
import com.baidu.cloud.thirdparty.jackson.databind.JsonNode;
import com.baidu.cloud.thirdparty.jackson.databind.ObjectMapper;
import com.baidu.cloud.thirdparty.jackson.databind.node.ArrayNode;
import com.baidu.cloud.thirdparty.jackson.databind.node.ObjectNode;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

public class PojoJsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Object[] realize(Object[] args, Type[] types) throws Exception {
        if (args == null) {
            return args;
        }
        if (args.length != types.length) {
            throw new IllegalArgumentException("args.length != types.length");
        }
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            if (arg instanceof String) {
                if (String.class.equals((Object)types[i])) {
                    result[i] = arg;
                    continue;
                }
                result[i] = OBJECT_MAPPER.readValue((String)arg, OBJECT_MAPPER.constructType(types[i]));
                continue;
            }
            String json = OBJECT_MAPPER.writeValueAsString(arg);
            result[i] = OBJECT_MAPPER.readValue(json, OBJECT_MAPPER.constructType(types[i]));
        }
        return result;
    }

    public static Object generalize(Object data) throws Exception {
        if (data == null) {
            return data;
        }
        String json = OBJECT_MAPPER.writeValueAsString(data);
        JsonNode jsonNode = OBJECT_MAPPER.readTree(json);
        if (jsonNode instanceof ObjectNode) {
            return OBJECT_MAPPER.readValue(json, Map.class);
        }
        if (jsonNode instanceof ArrayNode) {
            return OBJECT_MAPPER.readValue(json, List.class);
        }
        return data;
    }

    public static Object[] toJsonString(Object[] args) throws Exception {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = OBJECT_MAPPER.writeValueAsString(args[i]);
        }
        return result;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        OBJECT_MAPPER.setDateFormat((DateFormat)fmt);
    }
}

