/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.brpc;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.protocol.ProtocolEncoder;
import com.baidu.cloud.starlight.api.serialization.serializer.Serializer;
import com.baidu.cloud.starlight.api.utils.ByteArrayUtils;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.protocol.brpc.BrpcMeta;
import com.baidu.cloud.starlight.protocol.brpc.BrpcProtocol;
import com.baidu.cloud.starlight.protocol.brpc.BrpcRequestMeta;
import com.baidu.cloud.starlight.protocol.brpc.BrpcResponseMeta;
import com.baidu.cloud.starlight.protocol.brpc.CodeMapping;
import com.baidu.cloud.starlight.protocol.brpc.StarlightRequestMeta;
import com.baidu.cloud.starlight.protocol.brpc.StarlightResponseMeta;
import com.baidu.cloud.starlight.serialization.serializer.ProtoStuffSerializer;
import com.baidu.cloud.starlight.serialization.serializer.ProtobufSerializer;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBuf;
import com.baidu.cloud.thirdparty.netty.buffer.Unpooled;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class BrpcEncoder
implements ProtocolEncoder {
    @Override
    public ByteBuf encode(MsgBase input) throws CodecException {
        if (input == null) {
            throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "MsgBase is null, cannot encode");
        }
        if (input instanceof Request) {
            return this.encodeRequest((Request)input);
        }
        if (input instanceof Response) {
            return this.encodeResponse((Response)input);
        }
        throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "MsgBase type is illegal {" + input.getClass().getName() + "}, cannot encode");
    }

    private ByteBuf encodeRequest(Request request) {
        try {
            BrpcRequestMeta requestMeta = new BrpcRequestMeta();
            requestMeta.setLogId(request.getId());
            requestMeta.setServiceName(request.getServiceName());
            requestMeta.setMethodName(request.getMethodName());
            if (request.getAttachmentKv() != null) {
                Object parentSpanId;
                Object spanId;
                HashMap<String, Object> requestAttachKv = new HashMap<String, Object>(request.getAttachmentKv());
                requestAttachKv.remove("auth_data");
                requestAttachKv.remove("binary_attachment_size");
                requestAttachKv.remove("binary_attachment");
                Object traceId = requestAttachKv.remove("trace.id");
                if (traceId instanceof Long) {
                    requestMeta.setTraceId((Long)traceId);
                }
                if ((spanId = requestAttachKv.remove("span.id")) instanceof Long) {
                    requestMeta.setSpanId((Long)spanId);
                }
                if ((parentSpanId = requestAttachKv.remove("parent.span.id")) instanceof Long) {
                    requestMeta.setParentSpanId((Long)parentSpanId);
                }
                HashMap<String, Object> requestAttachKv2 = new HashMap<String, Object>(requestAttachKv);
                LinkedList<BrpcRequestMeta.BrpcRequestMetaExt> metaExtList = new LinkedList<BrpcRequestMeta.BrpcRequestMetaExt>();
                for (Map.Entry kv : requestAttachKv.entrySet()) {
                    if (kv.getKey() == null || kv.getValue() == null || !(kv.getValue() instanceof String)) continue;
                    BrpcRequestMeta.BrpcRequestMetaExt metaExt = new BrpcRequestMeta.BrpcRequestMetaExt();
                    metaExt.setKey((String)kv.getKey());
                    metaExt.setValue((String)kv.getValue());
                    metaExtList.add(metaExt);
                    requestAttachKv2.remove(kv.getKey());
                }
                requestMeta.setExtFields(metaExtList);
                if (requestAttachKv2.size() > 0) {
                    StarlightRequestMeta starlightRequestMeta = new StarlightRequestMeta();
                    starlightRequestMeta.setStarlightExtFields(requestAttachKv2);
                    requestMeta.setStarlightRequestMeta(starlightRequestMeta);
                }
            }
            BrpcMeta meta = new BrpcMeta();
            meta.setCorrelationId(request.getId());
            meta.setCompressType(request.getCompressType());
            meta.setRequest(requestMeta);
            if (request.getAttachmentKv() != null) {
                Object binarySizeObject;
                Object authObject = request.getAttachmentKv().get("auth_data");
                if (authObject instanceof String) {
                    String authData = (String)authObject;
                    meta.setAuthenticationData(authData.getBytes());
                }
                if ((binarySizeObject = request.getAttachmentKv().get("binary_attachment_size")) instanceof Integer) {
                    Integer binaryAttachmentSize = (Integer)binarySizeObject;
                    meta.setAttachmentSize(binaryAttachmentSize);
                }
            }
            Integer idStrategyFlag = BrpcProtocol.metaStrategyFlag(BrpcProtocol.bodySerMode(request));
            ProtoStuffSerializer serializer = (ProtoStuffSerializer)this.serializer("protostuff");
            return this.protocolEncode(serializer.serialize(meta, (Type)((Object)BrpcMeta.class), idStrategyFlag), request.getBodyBytes());
        }
        catch (Exception e) {
            throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "Use brpc encode request failed!", e);
        }
    }

    private ByteBuf encodeResponse(Response response) {
        Object binarySizeObject;
        BrpcMeta meta = new BrpcMeta();
        meta.setCorrelationId(response.getId());
        meta.setCompressType(response.getCompressType());
        BrpcResponseMeta responseMeta = new BrpcResponseMeta();
        responseMeta.setErrorCode(CodeMapping.getBrpcMappingOfStarlightNo(response.getStatus()));
        if (response.getErrorMsg() != null) {
            responseMeta.setErrorText(response.getErrorMsg());
        }
        responseMeta.setStarlightResponseMeta(this.generateStarlightRespMeta(response));
        meta.setResponse(responseMeta);
        if (response.getAttachmentKv() != null && (binarySizeObject = response.getAttachmentKv().get("binary_attachment_size")) instanceof Integer) {
            Integer binaryAttachmentSize = (Integer)binarySizeObject;
            meta.setAttachmentSize(binaryAttachmentSize);
        }
        Integer idStrategyFlag = BrpcProtocol.metaStrategyFlag(BrpcProtocol.bodySerMode(response.getRequest()));
        ProtoStuffSerializer serializer = (ProtoStuffSerializer)this.serializer("protostuff");
        return this.protocolEncode(serializer.serialize(meta, (Type)((Object)BrpcMeta.class), idStrategyFlag), response.getBodyBytes());
    }

    private StarlightResponseMeta generateStarlightRespMeta(Response response) {
        this.addAdditionalRespKv(response);
        StarlightResponseMeta starlightResponseMeta = new StarlightResponseMeta();
        starlightResponseMeta.setStarlightExtFields(response.getAttachmentKv());
        return starlightResponseMeta;
    }

    private ByteBuf protocolEncode(byte[] metaBytes, byte[] dataBytes) {
        ByteBuf headerBuf = Unpooled.buffer((int)12);
        headerBuf.writeBytes(BrpcProtocol.MAGIC_HEAD);
        int bodySize = metaBytes.length;
        if (dataBytes != null && dataBytes.length > 0) {
            bodySize += dataBytes.length;
        }
        headerBuf.writeInt(bodySize);
        headerBuf.writeInt(metaBytes.length);
        ByteBuf bodyBuf = null;
        bodyBuf = dataBytes != null && dataBytes.length > 0 ? Unpooled.wrappedBuffer((byte[][])new byte[][]{metaBytes, dataBytes}) : Unpooled.wrappedBuffer((byte[])metaBytes);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{headerBuf, bodyBuf});
    }

    @Override
    public void encodeBody(MsgBase msgBase) throws CodecException {
        if (msgBase == null) {
            throw new CodecException(CodecException.BODY_ENCODE_EXCEPTION, "MsgBase is null, cannot encode");
        }
        if (msgBase instanceof Request) {
            this.encodeRequestBody((Request)msgBase);
        }
        if (msgBase instanceof Response) {
            this.encodeResponseBody((Response)msgBase);
        }
        if (msgBase.getAttachmentKv() != null && msgBase.getAttachmentKv().get("binary_attachment") != null) {
            byte[] attachBinary = (byte[])msgBase.getAttachmentKv().get("binary_attachment");
            msgBase.getAttachmentKv().put("binary_attachment_size", attachBinary.length);
            byte[] bodyBytes = ByteArrayUtils.byteMerger(msgBase.getBodyBytes(), attachBinary);
            msgBase.setBodyBytes(bodyBytes);
        }
    }

    private void encodeRequestBody(Request request) throws CodecException {
        if (request.getServiceConfig() != null && !StringUtils.isEmpty(request.getServiceConfig().getSerializeMode())) {
            request.getAttachmentKv().put("serialize_mode", request.getServiceConfig().getSerializeMode());
        }
        if (request.getParams() == null || request.getParams().length == 0) {
            return;
        }
        Class<?>[] originParamTypes = request.getParamsTypes();
        Object[] originParams = request.getParams();
        BrpcProtocol.wrapReqParams(request);
        Serializer serializer = this.serializer(BrpcProtocol.bodySerType(request));
        byte[] bodyBytes = null;
        if (serializer instanceof ProtoStuffSerializer) {
            ProtoStuffSerializer protoStuffSer = (ProtoStuffSerializer)serializer;
            Integer idStrategyFlag = BrpcProtocol.bodyStrategyFlag(BrpcProtocol.bodySerMode(request));
            bodyBytes = protoStuffSer.serialize(request.getParams()[0], request.getParamsTypes()[0], idStrategyFlag);
        }
        if (serializer instanceof ProtobufSerializer) {
            bodyBytes = serializer.serialize(request.getParams()[0], request.getParamsTypes()[0]);
        }
        request.setBodyBytes(bodyBytes);
        request.setParams(originParams);
        request.setParamsTypes(originParamTypes);
    }

    private void encodeResponseBody(Response response) throws CodecException {
        if (response.getResult() == null) {
            return;
        }
        Object originRet = response.getResult();
        Class<?> originRetType = response.getReturnType();
        BrpcProtocol.wrapRespResult(response);
        Serializer serializer = this.serializer(BrpcProtocol.bodySerType(response.getRequest()));
        byte[] bodyBytes = null;
        if (serializer instanceof ProtoStuffSerializer) {
            Integer idStrategyFlag = BrpcProtocol.bodyStrategyFlag(BrpcProtocol.bodySerMode(response.getRequest()));
            ProtoStuffSerializer stuffSerializer = (ProtoStuffSerializer)serializer;
            bodyBytes = stuffSerializer.serialize(response.getResult(), response.getReturnType(), idStrategyFlag);
        }
        if (serializer instanceof ProtobufSerializer) {
            ProtobufSerializer protobufSerializer = (ProtobufSerializer)serializer;
            bodyBytes = protobufSerializer.serialize(response.getResult(), response.getReturnType());
        }
        response.setBodyBytes(bodyBytes);
        response.setResult(originRet);
        response.setReturnType(originRetType);
    }

    private Serializer serializer(String serializerType) {
        BrpcProtocol brpcProtocol = (BrpcProtocol)ExtensionLoader.getInstance(Protocol.class).getExtension("brpc");
        return brpcProtocol.getSerialize(serializerType);
    }
}

