/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.brpc;

import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.model.Wrapper;
import com.baidu.cloud.starlight.api.protocol.HeartbeatTrigger;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.protocol.ProtocolDecoder;
import com.baidu.cloud.starlight.api.protocol.ProtocolEncoder;
import com.baidu.cloud.starlight.api.serialization.serializer.Serializer;
import com.baidu.cloud.starlight.api.utils.GenericUtil;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.protocol.brpc.BrpcDecoder;
import com.baidu.cloud.starlight.protocol.brpc.BrpcEncoder;
import com.baidu.cloud.starlight.serialization.serializer.ProtoStuffSerializer;
import com.baidu.cloud.starlight.serialization.serializer.ProtobufSerializer;
import com.baidu.cloud.thirdparty.protostuff.runtime.DefaultIdStrategy;
import com.baidu.cloud.thirdparty.protostuff.runtime.IdStrategy;
import com.google.protobuf.MessageLite;
import java.util.Collection;
import java.util.Map;

public class BrpcProtocol
implements Protocol {
    public static final String SERIALIZER_TYPE_PROTOSTUFF = "protostuff";
    public static final String SERIALIZER_TYPE_PROTOBUF = "protobuf";
    protected static final String AUTH_KEY = "auth_data";
    public static final String PROTOCOL_NAME = "brpc";
    protected static final String BINARY_ATTACH_SIZE_KEY = "binary_attachment_size";
    protected static final String BINARY_ATTACH_KEY = "binary_attachment";
    protected static final int FIXED_LEN = 12;
    protected static final byte[] MAGIC_HEAD = "PRPC".getBytes();
    protected static final Integer MAX_BODY_SIZE = 0x20000000;
    protected static final IdStrategy IDSTRATEGY;
    private static final ProtocolEncoder ENCODER;
    private static final ProtocolDecoder DECODER;
    private static final Serializer PROTO_STUFF_SERIALIZER;
    private static final Serializer PROTOBUF_SERIALIZER;

    @Override
    public ProtocolEncoder getEncoder() {
        return ENCODER;
    }

    @Override
    public ProtocolDecoder getDecoder() {
        return DECODER;
    }

    @Override
    public HeartbeatTrigger getHeartbeatTrigger() {
        return null;
    }

    @Override
    public Serializer getSerialize() {
        return this.getSerialize(SERIALIZER_TYPE_PROTOSTUFF);
    }

    public Serializer getSerialize(String serializerType) {
        if (SERIALIZER_TYPE_PROTOBUF.equalsIgnoreCase(serializerType)) {
            return PROTOBUF_SERIALIZER;
        }
        return PROTO_STUFF_SERIALIZER;
    }

    public static Integer bodyStrategyFlag(String strategyType) {
        int flags = 0;
        flags |= 2;
        if (StringUtils.isEmpty(strategyType)) {
            return flags;
        }
        if (strategyType.equals("pb2-std")) {
            return flags;
        }
        if (strategyType.equals("pb2-java")) {
            return flags |= 4;
        }
        return flags;
    }

    public static Integer metaStrategyFlag(String strategyType) {
        int flags = 0;
        return flags |= 2;
    }

    public static String bodySerMode(Request request) {
        Object serMode;
        String serializeMode = null;
        if (request.getServiceConfig() != null && request.getServiceConfig().getSerializeMode() != null) {
            return request.getServiceConfig().getSerializeMode();
        }
        if (request.getAttachmentKv() != null && (serMode = request.getAttachmentKv().get("serialize_mode")) instanceof String) {
            serializeMode = (String)serMode;
        }
        return serializeMode;
    }

    public static String bodySerType(Request request) {
        if (request.getParamsTypes() != null && request.getParamsTypes().length == 1 && MessageLite.class.isAssignableFrom(request.getParamsTypes()[0])) {
            return SERIALIZER_TYPE_PROTOBUF;
        }
        if (request.getReturnType() != null && MessageLite.class.isAssignableFrom(request.getReturnType())) {
            return SERIALIZER_TYPE_PROTOBUF;
        }
        return SERIALIZER_TYPE_PROTOSTUFF;
    }

    public static void wrapReqParams(Request request) {
        String serializeMode = BrpcProtocol.bodySerMode(request);
        if (!StringUtils.isEmpty(serializeMode) && serializeMode.equalsIgnoreCase("pb2-java")) {
            request.setParams(new Object[]{new Wrapper<Object[]>(request.getParams())});
            request.setParamsTypes(new Class[]{Wrapper.class});
            return;
        }
        if (GenericUtil.isGenericMsg(request) || GenericUtil.isGenericCall(request)) {
            request.setParams(new Object[]{new Wrapper<Object[]>(request.getParams())});
            request.setParamsTypes(new Class[]{Wrapper.class});
            return;
        }
        if (request.getParamsTypes() != null && request.getParamsTypes().length > 1) {
            request.setParams(new Object[]{new Wrapper<Object[]>(request.getParams())});
            request.setParamsTypes(new Class[]{Wrapper.class});
            return;
        }
    }

    public static void wrapRespResult(Response response) {
        String serializeMode = BrpcProtocol.bodySerMode(response.getRequest());
        if (!StringUtils.isEmpty(serializeMode) && serializeMode.equalsIgnoreCase("pb2-java")) {
            response.setResult(new Wrapper<Object>(response.getResult()));
            response.setReturnType(Wrapper.class);
            return;
        }
        if (GenericUtil.isGenericMsg(response)) {
            response.setResult(new Wrapper<Object>(response.getResult()));
            response.setReturnType(Wrapper.class);
            return;
        }
    }

    public static boolean checkRequest(Request request) throws StarlightRpcException {
        String serializeMode = BrpcProtocol.bodySerMode(request);
        if (serializeMode == null || serializeMode.equals("pb2-std")) {
            if (request.getParamsTypes().length > 1 && !GenericUtil.isGenericCall(request)) {
                throw new StarlightRpcException(StarlightRpcException.BAD_REQUEST, "Multi-parameter calls are not allowed when use brpc std. To avoid exception use pb2-java serializeMode or Modify parameter type.");
            }
            if (Collection.class.isAssignableFrom(request.getReturnType()) || Map.class.isAssignableFrom(request.getReturnType())) {
                throw new StarlightRpcException(StarlightRpcException.BAD_REQUEST, "Return type is Collection or Map are not allowed when use brpc std. To avoid exception use pb2-java serializeMode or Modify return type.");
            }
        }
        if (request.getParamsTypes() != null && request.getParamsTypes().length > 1 && MessageLite.class.isAssignableFrom(request.getParamsTypes()[0])) {
            throw new StarlightRpcException(StarlightRpcException.BAD_REQUEST, "Multi-parameter calls are not allowed when use brpc std(protobuf message). To avoid exception modify method parameter info: only 1 param.");
        }
        return true;
    }

    static {
        ENCODER = new BrpcEncoder();
        DECODER = new BrpcDecoder();
        PROTO_STUFF_SERIALIZER = new ProtoStuffSerializer();
        PROTOBUF_SERIALIZER = new ProtobufSerializer();
        int flags = 0;
        IDSTRATEGY = new DefaultIdStrategy(flags |= 2);
    }
}

