/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.http;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.AbstractMsgBase;
import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.model.RpcResponse;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.protocol.ProtocolDecoder;
import com.baidu.cloud.starlight.api.serialization.serializer.Serializer;
import com.baidu.cloud.starlight.api.transport.buffer.DynamicCompositeByteBuf;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.protocol.http.HttpRequestResponseDecoder;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBuf;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandler;
import com.baidu.cloud.thirdparty.netty.channel.embedded.EmbeddedChannel;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpMessage;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpRequest;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpResponse;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderNames;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpDecoder
implements ProtocolDecoder {
    protected static final Logger LOGGER = LoggerFactory.getLogger(HttpDecoder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MsgBase decode(DynamicCompositeByteBuf input) throws CodecException {
        if (input.readableBytes() <= 0) {
            throw new CodecException(CodecException.PROTOCOL_INSUFFICIENT_DATA_EXCEPTION, "Too little data to parse using Http");
        }
        AbstractMsgBase msgBase = null;
        ByteBuf byteBuf = input.retainedSlice(input.readableBytes());
        FullHttpMessage httpMessage = null;
        EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestResponseDecoder()});
        try {
            embeddedChannel.writeInbound(new Object[]{byteBuf});
            httpMessage = (FullHttpMessage)embeddedChannel.readInbound();
            if (httpMessage == null || !httpMessage.decoderResult().isSuccess()) {
                LOGGER.debug("Cannot use Http protocol to decode: decoded result is null or failed");
                throw new CodecException(CodecException.PROTOCOL_DECODE_NOTMATCH_EXCEPTION, "Cannot use Http protocol to decode: decoded result is null");
            }
            if (httpMessage.headers() != null) {
                String[] splits;
                String contentType;
                String contentTypeAndEncoding;
                if (httpMessage.headers().get("x-starlight-id") == null) {
                    httpMessage.headers().add("x-starlight-id", (Object)"-1");
                    LOGGER.debug("Starlight id is null, make sure it is correct");
                }
                if (!StringUtils.isBlank(contentTypeAndEncoding = httpMessage.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) && !(contentType = (splits = contentTypeAndEncoding.split(";"))[0]).equals("application/json")) {
                    LOGGER.warn("ContentType id is not application/json, make sure it is a browser request");
                }
            } else {
                LOGGER.error("The http request not have headers, this is unlikely to happen");
            }
            if (httpMessage instanceof FullHttpRequest) {
                msgBase = this.reverseConvertRequest((FullHttpRequest)httpMessage);
            }
            if (httpMessage instanceof FullHttpResponse) {
                msgBase = this.reverseConvertResponse((FullHttpResponse)httpMessage);
            }
        }
        finally {
            if (httpMessage != null && httpMessage.decoderResult().isSuccess()) {
                input.skipBytes(byteBuf.readerIndex());
            }
            LOGGER.debug("input.retainedSlice bytebuf refCnt {}", (Object)byteBuf.refCnt());
            byteBuf.release();
            embeddedChannel.close();
        }
        return msgBase;
    }

    @Override
    public void decodeBody(MsgBase msgBase) throws CodecException {
        if (msgBase == null) {
            throw new CodecException(CodecException.BODY_DECODE_EXCEPTION, "Message is null to decode");
        }
        if (msgBase instanceof Request) {
            this.decodeRequestBody((Request)msgBase);
        }
        if (msgBase instanceof Response) {
            this.decodeResponseBody((Response)msgBase);
        }
    }

    private void decodeRequestBody(Request request) {
        if (request.getParams() == null || request.getParams().length == 0) {
            return;
        }
        if (request.getParamsTypes() == null) {
            throw new CodecException(CodecException.BODY_DECODE_EXCEPTION, "Body data type is null");
        }
        for (int i = 0; i < request.getParams().length; ++i) {
            Object bodyObj;
            byte[] bodyBytes;
            if (!(request.getParams()[i] instanceof byte[]) || (bodyBytes = (byte[])request.getParams()[i]) == null || bodyBytes.length <= 0) continue;
            Type bodyType = request.getGenericParamsTypes()[i];
            Serializer serializer = this.serializer(request.getProtocolName());
            request.getParams()[i] = bodyObj = serializer.deserialize(bodyBytes, bodyType);
            break;
        }
    }

    private void decodeResponseBody(Response response) {
        if (response.getBodyBytes() == null) {
            return;
        }
        Serializer serializer = this.serializer(response.getProtocolName());
        if (response.getStatus() != Constants.SUCCESS_CODE.intValue()) {
            response.setErrorMsg((String)serializer.deserialize(response.getBodyBytes(), (Type)((Object)String.class)));
        } else {
            if (response.getReturnType() == null) {
                throw new CodecException(CodecException.BODY_DECODE_EXCEPTION, "Body data type is null");
            }
            response.setResult(serializer.deserialize(response.getBodyBytes(), response.getGenericReturnType()));
        }
    }

    protected abstract Request reverseConvertRequest(FullHttpRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response reverseConvertResponse(FullHttpResponse httpResponse) {
        try {
            ByteBuf content;
            long corelationId = Long.parseLong(httpResponse.headers().get("x-starlight-id"));
            RpcResponse response = new RpcResponse(corelationId);
            response.setAttachmentKv(new HashMap<String, Object>());
            for (Map.Entry entry : httpResponse.headers().entries()) {
                response.getAttachmentKv().put((String)entry.getKey(), entry.getValue());
            }
            ((Response)response).setStatus(httpResponse.status().code());
            if (!httpResponse.status().equals((Object)HttpResponseStatus.OK)) {
                LOGGER.warn("Id:{}, response status is {}", (Object)response.getId(), (Object)((Response)response).getStatus());
                ((Response)response).setErrorMsg("Response is error, Id:" + response.getId() + ", response status is " + ((Response)response).getStatus());
            }
            if ((content = httpResponse.content()) != null && content.readableBytes() > 0) {
                byte[] contentBytes = new byte[content.readableBytes()];
                content.readBytes(contentBytes);
                response.setBodyBytes(contentBytes);
            }
            RpcResponse rpcResponse = response;
            return rpcResponse;
        }
        finally {
            httpResponse.release();
        }
    }

    protected Serializer serializer(String protocolName) {
        Protocol brpcProtocol = ExtensionLoader.getInstance(Protocol.class).getExtension(protocolName);
        return brpcProtocol.getSerialize();
    }
}

