/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.http;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.protocol.ProtocolEncoder;
import com.baidu.cloud.starlight.api.serialization.serializer.Serializer;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.protocol.http.AbstractHttpProtocol;
import com.baidu.cloud.starlight.protocol.http.springrest.NettyServletResponseAdaptor;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBuf;
import com.baidu.cloud.thirdparty.netty.buffer.Unpooled;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandler;
import com.baidu.cloud.thirdparty.netty.channel.embedded.EmbeddedChannel;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.DefaultFullHttpResponse;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpRequest;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpResponse;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderNames;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpRequestEncoder;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpResponseEncoder;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpResponseStatus;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpVersion;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class HttpEncoder
implements ProtocolEncoder {
    private static final Integer EMPTY_BODY_LENGTH = 0;

    @Override
    public ByteBuf encode(MsgBase input) throws CodecException {
        if (input == null) {
            throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "MsgBase is null, cannot encode");
        }
        if (input instanceof Request) {
            return this.encodeRequest((Request)input);
        }
        if (input instanceof Response) {
            return this.encodeResponse((Response)input);
        }
        throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "MsgBase type is illegal {" + input.getClass().getName() + "}, cannot encode");
    }

    private ByteBuf encodeRequest(Request request) {
        if (request.getParams() == null || !(request.getParams()[0] instanceof FullHttpRequest)) {
            throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "RpcRequest have not been converted to HttpRequest, please check");
        }
        FullHttpRequest httpRequest = (FullHttpRequest)request.getParams()[0];
        try (EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestEncoder()});){
            embeddedChannel.writeOutbound(new Object[]{httpRequest});
            if (embeddedChannel.outboundMessages() != null && embeddedChannel.outboundMessages().size() > 1) {
                ByteBuf[] outputBufs = new ByteBuf[embeddedChannel.outboundMessages().size()];
                embeddedChannel.outboundMessages().toArray(outputBufs);
                ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuf[])outputBufs);
                return byteBuf;
            }
            ByteBuf outputBufs = (ByteBuf)embeddedChannel.readOutbound();
            return outputBufs;
        }
    }

    private ByteBuf encodeResponse(Response response) {
        if (response.getResult() == null || !(response.getResult() instanceof FullHttpResponse)) {
            throw new CodecException(CodecException.PROTOCOL_ENCODE_EXCEPTION, "RpcResponse have not been converted to HttpResponse, please check");
        }
        FullHttpResponse httpResponse = (FullHttpResponse)response.getResult();
        try (EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});){
            embeddedChannel.writeOutbound(new Object[]{httpResponse});
            if (embeddedChannel.outboundMessages() != null && embeddedChannel.outboundMessages().size() > 1) {
                ByteBuf[] outputBufs = new ByteBuf[embeddedChannel.outboundMessages().size()];
                embeddedChannel.outboundMessages().toArray(outputBufs);
                ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuf[])outputBufs);
                return byteBuf;
            }
            ByteBuf outputBufs = (ByteBuf)embeddedChannel.readOutbound();
            return outputBufs;
        }
    }

    @Override
    public void encodeBody(MsgBase msgBase) throws CodecException {
        if (msgBase == null) {
            throw new CodecException(CodecException.BODY_ENCODE_EXCEPTION, "MsgBase is null, cannot encode");
        }
        if (msgBase instanceof Request) {
            this.encodeRequestBody((Request)msgBase);
        }
        if (msgBase instanceof Response) {
            this.encodeResponseBody((Response)msgBase);
        }
    }

    private void encodeRequestBody(Request request) {
        FullHttpRequest httpRequest = this.convertRequest(request);
        request.setParams(new Object[]{httpRequest});
    }

    private void encodeResponseBody(Response response) {
        FullHttpResponse httpResponse = this.convertResponse(response);
        response.setResult(httpResponse);
    }

    protected abstract FullHttpRequest convertRequest(Request var1);

    protected FullHttpResponse convertResponse(Response response) {
        FullHttpResponse httpResponse = null;
        if (this.hasHttpServletResponse(response)) {
            NettyServletResponseAdaptor servletResponseAdaptor = this.servletResponseAdaptor(response);
            httpResponse = servletResponseAdaptor.getNettyHttpResponse();
        } else {
            httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)AbstractHttpProtocol.UNKNOW_STATUS));
        }
        this.fulfillRpcResponse(httpResponse, response);
        httpResponse.headers().add("x-starlight-id", (Object)response.getId());
        if (response.getAttachmentKv() != null && response.getAttachmentKv().size() > 0) {
            for (Map.Entry<String, Object> kv : response.getAttachmentKv().entrySet()) {
                httpResponse.headers().add(kv.getKey(), kv.getValue());
            }
        }
        return httpResponse;
    }

    private boolean hasHttpServletResponse(Response response) {
        Map<String, Object> requestAttachKv;
        if (response.getRequest() == null) {
            return false;
        }
        Class<?>[] paramTypes = response.getRequest().getParamsTypes();
        if (paramTypes != null) {
            for (Class<?> paramClass : paramTypes) {
                if (!HttpServletResponse.class.isAssignableFrom(paramClass)) continue;
                return true;
            }
        }
        return (requestAttachKv = response.getRequest().getAttachmentKv()) != null && requestAttachKv.get("http_servlet_response") != null;
    }

    private NettyServletResponseAdaptor servletResponseAdaptor(Response response) {
        Map<String, Object> requestAttachKv;
        Object[] params = response.getRequest().getParams();
        if (params != null && params.length > 0) {
            for (Object param : params) {
                if (!(param instanceof NettyServletResponseAdaptor)) continue;
                return (NettyServletResponseAdaptor)param;
            }
        }
        if ((requestAttachKv = response.getRequest().getAttachmentKv()) != null && requestAttachKv.get("http_servlet_response") != null) {
            return (NettyServletResponseAdaptor)requestAttachKv.remove("http_servlet_response");
        }
        return null;
    }

    private Serializer serializer(String protocolName) {
        Protocol httpProtocol = ExtensionLoader.getInstance(Protocol.class).getExtension(protocolName);
        Serializer serializer = httpProtocol.getSerialize();
        return serializer;
    }

    protected void fulfillRpcResponse(FullHttpResponse httpResponse, Response response) {
        Serializer serializer = this.serializer(response.getProtocolName());
        if (httpResponse.status() == null || httpResponse.status().code() == AbstractHttpProtocol.UNKNOW_STATUS.intValue()) {
            if (response.getStatus() != Constants.SUCCESS_CODE.intValue()) {
                httpResponse.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            } else {
                httpResponse.setStatus(HttpResponseStatus.OK);
            }
        }
        if (!httpResponse.status().equals((Object)HttpResponseStatus.OK) && StringUtils.hasText(response.getErrorMsg())) {
            response.setBodyBytes(serializer.serialize(response.getErrorMsg(), (Type)((Object)String.class)));
        }
        if (httpResponse.status().equals((Object)HttpResponseStatus.OK) && response.getResult() != null) {
            if (AbstractHttpProtocol.isServletRequest(response.getRequest())) {
                if (response.getResult().getClass() == byte[].class) {
                    response.setBodyBytes((byte[])response.getResult());
                } else if (response.getResult() instanceof String) {
                    response.setBodyBytes(((String)response.getResult()).getBytes());
                } else {
                    response.setBodyBytes(serializer.serialize(response.getResult(), response.getGenericReturnType()));
                }
            } else {
                response.setBodyBytes(serializer.serialize(response.getResult(), response.getGenericReturnType()));
            }
        }
        if (response.getBodyBytes() != null && response.getBodyBytes().length > 0) {
            httpResponse.content().writeBytes(response.getBodyBytes());
        }
        int contentLength = httpResponse.content().readableBytes();
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentLength);
    }
}

