/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.http;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.protocol.http.HttpRequestResponseAggregator;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBuf;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandlerContext;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.DefaultFullHttpRequest;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.DefaultFullHttpResponse;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.DefaultHttpRequest;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.DefaultHttpResponse;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpMessage;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpMethod;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpObjectDecoder;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpResponseStatus;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpVersion;
import com.baidu.cloud.thirdparty.netty.util.ReferenceCounted;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestResponseDecoder
extends HttpObjectDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestResponseDecoder.class);
    private static final String HTTP = "HTTP";
    private static final HttpResponseStatus UNKNOWN_STATUS = new HttpResponseStatus(999, "Unknown");
    private Boolean isRequest = false;
    private static final Integer MAX_CONTENT_LENGTH = 0x20000000;
    private static final Integer MAX_HEADER_SIZE = 8192;
    private static final Integer MAX_INIT_LINE_LENGTH = 4096;

    public HttpRequestResponseDecoder() {
        super(MAX_INIT_LINE_LENGTH.intValue(), MAX_HEADER_SIZE.intValue(), MAX_CONTENT_LENGTH.intValue(), true);
    }

    protected boolean isDecodingRequest() {
        return this.isRequest;
    }

    protected HttpMessage createMessage(String[] initialLine) throws Exception {
        if (initialLine[0].contains(HTTP)) {
            this.isRequest = false;
            return new DefaultHttpResponse(HttpVersion.valueOf((String)initialLine[0]), HttpResponseStatus.valueOf((int)Integer.parseInt(initialLine[1]), (String)initialLine[2]), this.validateHeaders);
        }
        this.isRequest = true;
        return new DefaultHttpRequest(HttpVersion.valueOf((String)initialLine[2]), HttpMethod.valueOf((String)initialLine[0]), initialLine[1], this.validateHeaders);
    }

    protected HttpMessage createInvalidMessage() {
        if (this.isRequest.booleanValue()) {
            return new DefaultFullHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.GET, "/bad-request", this.validateHeaders);
        }
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_0, UNKNOWN_STATUS, this.validateHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        LinkedList httpMessageParts = new LinkedList();
        LinkedList allHttpMessageParts = new LinkedList();
        LinkedList<Object> fullHttpMessages = new LinkedList<Object>();
        HttpRequestResponseAggregator aggregator = new HttpRequestResponseAggregator(MAX_CONTENT_LENGTH);
        try {
            while (buffer.isReadable()) {
                HttpMessage requestHeader;
                String contentLengthStr;
                int oldPartSize = httpMessageParts.size();
                int oldBufferLength = buffer.readableBytes();
                super.decode(ctx, buffer, httpMessageParts);
                if (oldPartSize == httpMessageParts.size() && oldBufferLength == buffer.readableBytes()) {
                    LOGGER.warn("Decode one time without reading any bytes, this is unlikely to happen");
                    break;
                }
                if (httpMessageParts.size() == 1 && httpMessageParts.get(0) instanceof HttpMessage && buffer.isReadable() && StringUtils.isNumeric(contentLengthStr = (requestHeader = (HttpMessage)httpMessageParts.get(0)).headers().get("Content-Length"))) {
                    int length = Integer.parseInt(contentLengthStr);
                    if (length > MAX_CONTENT_LENGTH) {
                        LOGGER.error("Content-Length of request {} is {}, bigger than the max {}", new Object[]{requestHeader instanceof DefaultHttpRequest ? ((DefaultHttpRequest)requestHeader).uri() : requestHeader, length, MAX_CONTENT_LENGTH});
                    }
                    LOGGER.debug("Content-Length of request {} is {}, readable bytebuf is {}", new Object[]{requestHeader instanceof DefaultHttpRequest ? ((DefaultHttpRequest)requestHeader).uri() : requestHeader, length, buffer.readableBytes()});
                    buffer = buffer.readSlice(length);
                }
                allHttpMessageParts.addAll(httpMessageParts);
                for (Object httpMessagePart : httpMessageParts) {
                    aggregator.aggregate(ctx, httpMessagePart, fullHttpMessages);
                    if (fullHttpMessages.size() <= 0) continue;
                    out.add(fullHttpMessages.get(0));
                    return;
                }
                httpMessageParts.clear();
            }
        }
        finally {
            LOGGER.debug("allHttpMessageParts size {}", (Object)allHttpMessageParts.size());
            LOGGER.debug("fullHttpMessages size {}", (Object)fullHttpMessages.size());
            if (allHttpMessageParts.size() > 0 && fullHttpMessages.isEmpty()) {
                LOGGER.info("allHttpMessageParts size {}, fullHttpMessage size {}, will release", (Object)allHttpMessageParts.size(), (Object)fullHttpMessages.size());
                allHttpMessageParts.forEach(part -> {
                    ReferenceCounted refer;
                    int refCnt;
                    if (part instanceof ReferenceCounted && (refCnt = (refer = (ReferenceCounted)part).refCnt()) > 0) {
                        refer.release(refCnt);
                    }
                });
            }
            if (fullHttpMessages.isEmpty()) {
                LOGGER.debug("release aggregator's currentMessage(directByteBuf)");
                aggregator.handlerRemoved(ctx);
            }
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            LinkedList<Object> out = new LinkedList<Object>();
            try {
                this.decode(ctx, (ByteBuf)msg, out);
            }
            catch (Exception e) {
                LOGGER.debug("Bytebuf cannot be decoded by http protocol, will retry another protocol. the reason is : {}", (Object)e.getMessage());
                throw new CodecException(CodecException.PROTOCOL_DECODE_NOTMATCH_EXCEPTION, "Bytebuf cannot be decoded by http protocol, will retry another protocol. The reason is " + e.getMessage());
            }
            finally {
                for (Object e : out) {
                    ctx.fireChannelRead(e);
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }
}

