/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.http.springrest;

import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.starlight.protocol.http.springrest.ByteBufServletInputStream;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBufInputStream;
import com.baidu.cloud.thirdparty.netty.buffer.Unpooled;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpRequest;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderNames;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.cookie.ServerCookieDecoder;
import com.baidu.cloud.thirdparty.servlet.AsyncContext;
import com.baidu.cloud.thirdparty.servlet.DispatcherType;
import com.baidu.cloud.thirdparty.servlet.RequestDispatcher;
import com.baidu.cloud.thirdparty.servlet.ServletContext;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.servlet.ServletInputStream;
import com.baidu.cloud.thirdparty.servlet.ServletRequest;
import com.baidu.cloud.thirdparty.servlet.ServletResponse;
import com.baidu.cloud.thirdparty.servlet.http.Cookie;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletRequest;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.servlet.http.HttpSession;
import com.baidu.cloud.thirdparty.servlet.http.HttpUpgradeHandler;
import com.baidu.cloud.thirdparty.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NettyServletRequestAdaptor
implements HttpServletRequest {
    private FullHttpRequest nettyHttpRequest;
    private final String requestURI;
    private final String queryString;
    private final Map<String, String[]> params;
    private final Map<String, Object> attributes;
    private final ByteBufServletInputStream inputStream;
    private Channel channel;
    private Locale locale;

    public NettyServletRequestAdaptor(FullHttpRequest fullHttpRequest, Channel channel) {
        this(fullHttpRequest);
        this.channel = channel;
        this.locale = Locale.getDefault();
    }

    public NettyServletRequestAdaptor(FullHttpRequest fullHttpRequest) {
        this.nettyHttpRequest = fullHttpRequest;
        this.params = new ConcurrentHashMap<String, String[]>();
        this.attributes = new ConcurrentHashMap<String, Object>();
        if (this.nettyHttpRequest.uri().contains("?")) {
            String[] strs = this.nettyHttpRequest.uri().split("\\?");
            this.requestURI = strs[0];
            this.queryString = strs[1];
        } else {
            this.requestURI = this.nettyHttpRequest.uri();
            this.queryString = null;
        }
        if (!StringUtils.isBlank(this.queryString)) {
            String[] paramsStrs;
            for (String paramStr : paramsStrs = this.queryString.split("&")) {
                String[] paramArr = paramStr.split("=");
                String key = paramArr[0];
                String value = paramArr[1];
                if (this.params.get(key) == null) {
                    this.params.put(key, new String[]{value});
                    continue;
                }
                List<Object> values = Arrays.asList((Object[])this.params.get(key));
                values.add(value);
                String[] valueArr = new String[]{};
                values.toArray(valueArr);
                this.params.put(key, valueArr);
            }
        }
        byte[] requestBytes = new byte[this.nettyHttpRequest.content().readableBytes()];
        this.nettyHttpRequest.content().readBytes(requestBytes);
        this.inputStream = new ByteBufServletInputStream(new ByteBufInputStream(Unpooled.wrappedBuffer((byte[])requestBytes)));
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        Set cookieSet;
        String cookieString = this.nettyHttpRequest.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (!StringUtils.isBlank(cookieString) && (cookieSet = ServerCookieDecoder.LAX.decode(cookieString)) != null && cookieSet.size() > 0) {
            Cookie[] cookies = new Cookie[cookieSet.size()];
            int index = 0;
            for (com.baidu.cloud.thirdparty.netty.handler.codec.http.cookie.Cookie nettyCookie : cookieSet) {
                Cookie cookie = new Cookie(nettyCookie.name(), nettyCookie.value());
                cookie.setDomain(nettyCookie.domain() == null ? "" : nettyCookie.domain());
                cookie.setMaxAge((int)nettyCookie.maxAge());
                cookie.setPath(nettyCookie.path());
                cookie.setHttpOnly(nettyCookie.isHttpOnly());
                cookie.setSecure(nettyCookie.isSecure());
                cookies[index] = cookie;
                ++index;
            }
            return cookies;
        }
        return new Cookie[0];
    }

    public long getDateHeader(String name) {
        return 0L;
    }

    public String getHeader(String name) {
        return this.nettyHttpRequest.headers().get(name);
    }

    public Enumeration<String> getHeaders(String name) {
        final Iterator headersIterator = this.nettyHttpRequest.headers().getAll(name).iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return headersIterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)headersIterator.next();
            }
        };
    }

    public Enumeration<String> getHeaderNames() {
        final Iterator headerNamesIterator = this.nettyHttpRequest.headers().names().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return headerNamesIterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)headerNamesIterator.next();
            }
        };
    }

    public int getIntHeader(String name) {
        return Integer.parseInt(this.nettyHttpRequest.headers().get(name));
    }

    public String getMethod() {
        return this.nettyHttpRequest.method().name();
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        String requestURI = this.getRequestURI();
        return "/".equals(requestURI) ? "" : requestURI;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer requestURLBuffer = new StringBuffer();
        requestURLBuffer.append(this.getScheme());
        requestURLBuffer.append("://");
        requestURLBuffer.append(this.getLocalAddr());
        requestURLBuffer.append(":");
        requestURLBuffer.append(this.getLocalPort());
        requestURLBuffer.append(this.getRequestURI());
        return requestURLBuffer;
    }

    public String getServletPath() {
        return this.requestURI;
    }

    public HttpSession getSession(boolean create) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor Not support login current");
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor Not support logout current");
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor Not support logout current");
    }

    public Part getPart(String name) throws IOException, ServletException {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor Not support logout current");
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor Not support upgrade current");
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        final Iterator<String> iterator = this.attributes.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor not support set charset encoding");
    }

    public int getContentLength() {
        return this.getIntHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
    }

    public long getContentLengthLong() {
        return this.getIntHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
    }

    public String getContentType() {
        return this.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public String getParameter(String name) {
        return this.params.get(name) == null ? null : this.params.get(name)[0];
    }

    public Enumeration<String> getParameterNames() {
        final Iterator<String> iterator = this.params.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    public String[] getParameterValues(String name) {
        return this.params.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.params;
    }

    public String getProtocol() {
        return this.nettyHttpRequest.protocolVersion().protocolName();
    }

    public String getScheme() {
        return this.nettyHttpRequest.protocolVersion().protocolName().toLowerCase();
    }

    public String getServerName() {
        return this.getRemoteHost();
    }

    public int getServerPort() {
        return this.getRemotePort();
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor not support getReader");
    }

    public String getRemoteAddr() {
        String remoteAddr = this.getHeader("X-Forwarded-For");
        if (StringUtils.isEmpty(remoteAddr)) {
            if (this.channel == null) {
                throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to getRemoteHost without channel");
            }
            InetSocketAddress insocket = (InetSocketAddress)this.channel.remoteAddress();
            remoteAddr = insocket.getAddress().getHostAddress();
        }
        return remoteAddr;
    }

    public String getRemoteHost() {
        if (this.channel == null) {
            throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to getRemoteHost without channel");
        }
        InetSocketAddress insocket = (InetSocketAddress)this.channel.remoteAddress();
        return insocket.getHostName();
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<Locale> getLocales() {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to getLocales");
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to getRequestDispatcher");
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to getRealPath");
    }

    public int getRemotePort() {
        if (this.channel == null) {
            throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to getRemotePort without channel");
        }
        InetSocketAddress insocket = (InetSocketAddress)this.channel.remoteAddress();
        return insocket.getPort();
    }

    public String getLocalName() {
        if (this.channel == null) {
            throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to getLocalName without channel");
        }
        InetSocketAddress insocket = (InetSocketAddress)this.channel.localAddress();
        return insocket.getHostName();
    }

    public String getLocalAddr() {
        if (this.channel == null) {
            throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to getLocalAddr without channel");
        }
        InetSocketAddress insocket = (InetSocketAddress)this.channel.localAddress();
        return insocket.getAddress().getHostAddress();
    }

    public int getLocalPort() {
        if (this.channel == null) {
            throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to getLocalPort without channel");
        }
        InetSocketAddress insocket = (InetSocketAddress)this.channel.localAddress();
        return insocket.getPort();
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to startAsync");
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException("NettyServletRequestAdaptor not support to startAsync");
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public FullHttpRequest getNettyHttpRequest() {
        return this.nettyHttpRequest;
    }

    public void setNettyHttpRequest(FullHttpRequest nettyHttpRequest) {
        this.nettyHttpRequest = nettyHttpRequest;
    }
}

