/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.protocol.http.springrest;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.model.RpcRequest;
import com.baidu.cloud.starlight.api.model.RpcResponse;
import com.baidu.cloud.starlight.api.transport.channel.ThreadLocalChannelContext;
import com.baidu.cloud.starlight.protocol.http.AbstractHttpProtocol;
import com.baidu.cloud.starlight.protocol.http.HttpDecoder;
import com.baidu.cloud.starlight.protocol.http.springrest.NettyServletRequestAdaptor;
import com.baidu.cloud.starlight.protocol.http.springrest.NettyServletResponseAdaptor;
import com.baidu.cloud.starlight.protocol.http.springrest.SpringRestHandlerMapping;
import com.baidu.cloud.starlight.protocol.http.springrest.SpringRestHttpEncoder;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.DefaultFullHttpResponse;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpRequest;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.FullHttpResponse;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpResponseStatus;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpVersion;
import com.baidu.cloud.thirdparty.servlet.ServletException;
import com.baidu.cloud.thirdparty.springframework.http.HttpHeaders;
import com.baidu.cloud.thirdparty.springframework.http.converter.HttpMessageConversionException;
import com.baidu.cloud.thirdparty.springframework.web.method.HandlerMethod;
import com.baidu.cloud.thirdparty.springframework.web.servlet.NoHandlerFoundException;
import java.util.HashMap;
import java.util.Map;

public class SpringRestHttpDecoder
extends HttpDecoder {
    @Override
    protected Request reverseConvertRequest(FullHttpRequest httpRequest) {
        long corelationId = Long.parseLong(httpRequest.headers().get("x-starlight-id"));
        RpcRequest request = new RpcRequest(corelationId);
        request.setProtocolName("springrest");
        request.setAttachmentKv(new HashMap<String, Object>());
        for (Map.Entry entry : httpRequest.headers().entries()) {
            request.getAttachmentKv().put((String)entry.getKey(), entry.getValue());
        }
        Channel channel = ThreadLocalChannelContext.getContext().getChannel();
        NettyServletRequestAdaptor servletRequestAdaptor = new NettyServletRequestAdaptor(httpRequest, channel);
        NettyServletResponseAdaptor servletResponseAdaptor = new NettyServletResponseAdaptor((FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)AbstractHttpProtocol.UNKNOW_STATUS)), servletRequestAdaptor);
        request.getAttachmentKv().put("http_servlet_request", servletRequestAdaptor);
        request.getAttachmentKv().put("http_servlet_response", servletResponseAdaptor);
        try {
            SpringRestHandlerMapping handlerMapping = SpringRestHandlerMapping.getInstance();
            HandlerMethod handlerMethod = handlerMapping.handler(servletRequestAdaptor);
            if (handlerMethod == null) {
                throw new NoHandlerFoundException(servletRequestAdaptor.getMethod(), servletRequestAdaptor.getRequestURI(), new HttpHeaders());
            }
            Class<?> serviceClass = handlerMethod.getBeanType();
            if (serviceClass.getInterfaces().length > 0) {
                serviceClass = serviceClass.getInterfaces()[0];
            }
            ((Request)request).setServiceName(serviceClass.getName());
            ((Request)request).setMethodName(handlerMethod.getMethod().getName());
            ((Request)request).setParamsTypes(handlerMethod.getMethod().getParameterTypes());
            ((Request)request).setGenericParamsTypes(handlerMethod.getMethod().getGenericParameterTypes());
            ((Request)request).setMethod(handlerMethod.getMethod());
            ((Request)request).setServiceObj(handlerMethod.getBean());
            Object[] args = handlerMapping.resolveArguments(handlerMethod, servletRequestAdaptor, servletResponseAdaptor);
            ((Request)request).setParams(args);
            RpcRequest rpcRequest = request;
            return rpcRequest;
        }
        catch (Exception e) {
            if (e instanceof ServletException || e instanceof HttpMessageConversionException) {
                this.responseNotSupport(request, servletResponseAdaptor, channel, e.getMessage());
                throw new CodecException(CodecException.PROTOCOL_DECODE_EXCEPTION, "Error occur when use SpringRestHttpDecoder to reverseConvertRequest: " + e.getMessage());
            }
            if (e instanceof CodecException) {
                throw (CodecException)e;
            }
            throw new CodecException(CodecException.PROTOCOL_DECODE_NOTMATCH_EXCEPTION, "Cannot not use SpringRestProtocol to decode request bytes");
        }
        finally {
            if (httpRequest.refCnt() > 0) {
                LOGGER.debug("Release httpRequest refCnt {}", (Object)httpRequest.refCnt());
                httpRequest.release();
            }
        }
    }

    private void responseNotSupport(Request request, NettyServletResponseAdaptor servletResponseAdaptor, Channel channel, String errorMsg) {
        RpcResponse response = new RpcResponse(request.getId());
        response.setProtocolName("springrest");
        ((Response)response).setStatus(CodecException.PROTOCOL_DECODE_EXCEPTION);
        ((Response)response).setErrorMsg(errorMsg);
        ((Response)response).setRequest(request);
        try {
            servletResponseAdaptor.setStatus(HttpResponseStatus.NOT_FOUND.code());
            SpringRestHttpEncoder encoder = new SpringRestHttpEncoder();
            encoder.encodeBody(response);
            channel.writeAndFlush((Object)response);
        }
        catch (CodecException e) {
            LOGGER.error("Error occur when return uri not support error to request, cause by {}", (Object)e.getMessage());
        }
    }

    @Override
    protected Response reverseConvertResponse(FullHttpResponse httpResponse) {
        Response response = super.reverseConvertResponse(httpResponse);
        if (response != null) {
            response.setProtocolName("springrest");
        }
        return response;
    }
}

