/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.serialization.serializer;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.serialization.serializer.Serializer;
import com.baidu.cloud.thirdparty.dyuprotostuff.LinkedBuffer;
import com.baidu.cloud.thirdparty.dyuprotostuff.ProtobufIOUtil;
import com.baidu.cloud.thirdparty.dyuprotostuff.Schema;
import com.baidu.cloud.thirdparty.dyuprotostuff.runtime.DefaultIdStrategy;
import com.baidu.cloud.thirdparty.dyuprotostuff.runtime.IdStrategy;
import com.baidu.cloud.thirdparty.dyuprotostuff.runtime.RuntimeSchema;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DyuProtostuffSerializer
implements Serializer {
    private static final int DEFAULT_ALLOCATE_NUM = 512;
    private ThreadLocal<LinkedBuffer> buffer = new ThreadLocal<LinkedBuffer>(){

        @Override
        protected LinkedBuffer initialValue() {
            return LinkedBuffer.allocate((int)512);
        }
    };
    private Map<ClassLoader, IdStrategy> idStrategyMap = new ConcurrentHashMap<ClassLoader, IdStrategy>();

    @Override
    public byte[] serialize(Object obj, Type type) throws CodecException {
        if (obj == null) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "The message used to dyuprotostuff-serialize is null");
        }
        if (!(type instanceof Class)) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "The type to dyuprotostuff-serialize is not Class");
        }
        Class clazz = (Class)type;
        if (!this.isSupported(clazz)) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "The type {" + type + "} used to dyuprotostuff-deserialize is illegal");
        }
        long starTime = System.currentTimeMillis();
        try {
            Schema schema = RuntimeSchema.getSchema((Class)clazz, (IdStrategy)this.getIdStrategy());
            byte[] result = ProtobufIOUtil.toByteArray((Object)obj, (Schema)schema, (LinkedBuffer)this.buffer.get());
            LOGGER.debug("Serialize obj cost: {}", (Object)(System.currentTimeMillis() - starTime));
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "DyuProtostuff serialize error: " + e.getMessage(), e);
        }
        finally {
            this.buffer.get().clear();
        }
    }

    @Override
    public Object deserialize(byte[] bytes, Type type) throws CodecException {
        if (bytes == null || bytes.length == 0) {
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "The bytes used to dyuprotostuff deserializing are empty");
        }
        if (!(type instanceof Class)) {
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "The type to dyuprotostuff deserializing is not Class");
        }
        Class clazz = (Class)type;
        if (!this.isSupported(clazz)) {
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "The type used to dyuprotostuff deserializing are illegal");
        }
        long starTime = System.currentTimeMillis();
        try {
            Schema schema = RuntimeSchema.getSchema((Class)clazz, (IdStrategy)this.getIdStrategy());
            Object content = schema.newMessage();
            ProtobufIOUtil.mergeFrom((byte[])bytes, (Object)content, (Schema)schema);
            LOGGER.debug("Serialize obj cost: {}", (Object)(System.currentTimeMillis() - starTime));
            return content;
        }
        catch (Exception e) {
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "DyuProtostuff Deserialize error: " + e.getMessage(), e);
        }
    }

    private boolean isSupported(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return !clazz.isPrimitive();
    }

    private IdStrategy getIdStrategy() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        IdStrategy strategy = this.idStrategyMap.get(classLoader);
        if (strategy == null) {
            this.idStrategyMap.putIfAbsent(classLoader, (IdStrategy)new DefaultIdStrategy());
            strategy = this.idStrategyMap.get(classLoader);
        }
        return strategy;
    }
}

