/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.serialization.serializer;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.serialization.serializer.Serializer;
import com.baidu.cloud.thirdparty.jackson.annotation.JsonInclude;
import com.baidu.cloud.thirdparty.jackson.databind.DeserializationFeature;
import com.baidu.cloud.thirdparty.jackson.databind.JavaType;
import com.baidu.cloud.thirdparty.jackson.databind.ObjectMapper;
import com.baidu.cloud.thirdparty.jackson.databind.SerializationFeature;
import com.baidu.cloud.thirdparty.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer
implements Serializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonSerializer.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    public byte[] serialize(Object obj, Type type) throws CodecException {
        if (obj == null) {
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "The message used to json-serialize is null");
        }
        try {
            return OBJECT_MAPPER.writeValueAsBytes(obj);
        }
        catch (Throwable e) {
            LOGGER.error("JsonSerializer bodySerialize fail: ", e);
            throw new CodecException(CodecException.SERIALIZE_EXCEPTION, "Json serialize error: " + e.getMessage(), e);
        }
    }

    @Override
    public Object deserialize(byte[] bytes, Type type) throws CodecException {
        if (bytes == null || bytes.length == 0) {
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "The bytes used to json deserialize are empty");
        }
        try {
            return OBJECT_MAPPER.readValue(bytes, this.getJavaType(type));
        }
        catch (Throwable e) {
            LOGGER.error("JsonSerializer bodyDeserialize fail: ", e);
            throw new CodecException(CodecException.DESERIALIZE_EXCEPTION, "Json deserialize error: " + e.getMessage(), e);
        }
    }

    private JavaType getJavaType(Type type) {
        TypeFactory typeFactory = OBJECT_MAPPER.getTypeFactory();
        return typeFactory.constructType(type);
    }

    static {
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        OBJECT_MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

