/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.transport.channel;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.transport.channel.RpcChannelGroup;
import com.baidu.cloud.thirdparty.netty.bootstrap.Bootstrap;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyRpcChannelGroup
implements RpcChannelGroup {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NettyRpcChannelGroup.class);
    private URI uri;
    private final Bootstrap bootstrap;

    public NettyRpcChannelGroup(URI uri, Bootstrap bootstrap) {
        this.uri = uri;
        this.bootstrap = bootstrap;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public synchronized Channel connect() throws TransportException {
        ChannelFuture channelFuture = null;
        try {
            channelFuture = this.bootstrap.connect((SocketAddress)this.getConnectAddress());
            int connectTimeout = this.uri.getParameter("connect_timeout", Constants.CONNECT_TIMEOUT_VALUE);
            channelFuture.awaitUninterruptibly((long)connectTimeout);
            if (channelFuture.isSuccess()) {
                Channel result = channelFuture.channel();
                LOGGER.info("Create new channel {}, remoteAddress {}", (Object)result.id().asLongText(), (Object)result.remoteAddress());
                return result;
            }
            String causeByMsg = channelFuture.cause() == null ? "Connect timeout" : channelFuture.cause().getMessage();
            LOGGER.info("Create new channel failed, remoteAddress {}, cause by {}", (Object)this.getConnectAddress(), (Object)causeByMsg);
            throw new TransportException(TransportException.CONNECT_EXCEPTION, "Connect to url:" + this.getUri().getHost() + ":" + this.getUri().getPort() + " failed,  cause by : " + causeByMsg);
        }
        catch (Exception e) {
            if (e instanceof TransportException) {
                throw e;
            }
            if (channelFuture != null) {
                String causeByMsg = channelFuture.cause() == null ? "Connect timeout" : channelFuture.cause().getMessage();
                LOGGER.info("Create new channel failed, remoteAddress {}, cause by {}", (Object)this.getConnectAddress(), (Object)causeByMsg);
                throw new TransportException(TransportException.CONNECT_EXCEPTION, "Connect to url:" + this.getUri().getHost() + ":" + this.getUri().getPort() + " failed,  cause by : " + causeByMsg);
            }
            throw new TransportException(TransportException.CONNECT_EXCEPTION, e.getMessage(), e);
        }
    }

    protected InetSocketAddress getConnectAddress() {
        return new InetSocketAddress(this.getUri().getHost(), this.getUri().getPort());
    }
}

