/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.transport.channel;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.rpc.LocalContext;
import com.baidu.cloud.starlight.api.transport.channel.RpcChannel;
import com.baidu.cloud.starlight.transport.channel.ChannelPooledObjectFactory;
import com.baidu.cloud.starlight.transport.channel.NettyRpcChannelGroup;
import com.baidu.cloud.thirdparty.netty.bootstrap.Bootstrap;
import com.baidu.cloud.thirdparty.pool2.PooledObject;
import com.baidu.cloud.thirdparty.pool2.PooledObjectFactory;
import com.baidu.cloud.thirdparty.pool2.impl.DefaultPooledObjectInfo;
import com.baidu.cloud.thirdparty.pool2.impl.GenericObjectPool;
import com.baidu.cloud.thirdparty.pool2.impl.GenericObjectPoolConfig;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

public class PooledRpcChannelGroup
extends NettyRpcChannelGroup {
    private GenericObjectPool<RpcChannel> channelPool;

    public PooledRpcChannelGroup(URI uri, Bootstrap bootstrap) {
        super(uri, bootstrap);
    }

    @Override
    public RpcChannel getRpcChannel() {
        try {
            RpcChannel rpcChannel = (RpcChannel)this.channelPool.borrowObject();
            LocalContext.getContext("thread.classloader").set(rpcChannel.channel().id().asLongText(), Thread.currentThread().getContextClassLoader());
            return rpcChannel;
        }
        catch (Exception e) {
            throw new TransportException(TransportException.CONNECT_EXCEPTION, "Get Channel from pool failed :" + e.getMessage());
        }
    }

    @Override
    public void returnRpcChannel(RpcChannel rpcChannel) {
        try {
            this.channelPool.returnObject((Object)rpcChannel);
        }
        catch (Exception e) {
            LOGGER.debug("Return channel failed:{} to PooledChannel", (Object)e.getMessage());
        }
    }

    @Override
    public void removeRpcChannel(RpcChannel rpcChannel) {
        try {
            this.channelPool.invalidateObject((Object)rpcChannel);
        }
        catch (Exception e) {
            LOGGER.debug("Remove channel failed from PooledChannelGroup.", (Throwable)e);
        }
    }

    @Override
    public int rpcChannelCount() {
        return this.channelPool.listAllObjects().size();
    }

    @Override
    public void init() {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxWaitMillis((long)this.getUri().getParameter("connect_timeout", Constants.CONNECT_TIMEOUT_VALUE));
        poolConfig.setMaxTotal(this.getUri().getParameter("max_connections", Constants.MAX_TOTAL_CONNECTIONS));
        poolConfig.setMaxIdle(this.getUri().getParameter("max_idle_connections", Constants.MAX_IDLE_CONNECTIONS));
        poolConfig.setMinIdle(this.getUri().getParameter("min_idle_connections", Constants.MIN_IDLE_CONNECTIONS));
        poolConfig.setTestWhileIdle(true);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTimeBetweenEvictionRunsMillis((long)Constants.TIME_BETWEEN_EVICTION_RUN_MILLS.intValue());
        this.channelPool = new GenericObjectPool((PooledObjectFactory)new ChannelPooledObjectFactory(this), poolConfig);
        try {
            this.channelPool.preparePool();
        }
        catch (Exception e) {
            LOGGER.warn("Init min idle object pool failed");
        }
    }

    @Override
    public void close() {
        this.channelPool.close();
    }

    @Override
    public Set<RpcChannel> allRpcChannels() {
        HashSet<RpcChannel> rpcChannels = new HashSet<RpcChannel>();
        Set pooledObjectInfos = this.channelPool.listAllObjects();
        try {
            for (DefaultPooledObjectInfo pooledObjectInfo : pooledObjectInfos) {
                Field pooledObjectField = pooledObjectInfo.getClass().getDeclaredField("pooledObject");
                pooledObjectField.setAccessible(true);
                PooledObject pooledObject = (PooledObject)pooledObjectField.get(pooledObjectInfo);
                rpcChannels.add((RpcChannel)pooledObject.getObject());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Get all rpcChannels from PooledChannelGroup failed", (Throwable)e);
        }
        return rpcChannels;
    }
}

