/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.transport.channel;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.rpc.LocalContext;
import com.baidu.cloud.starlight.api.transport.channel.ChannelSide;
import com.baidu.cloud.starlight.api.transport.channel.RpcChannel;
import com.baidu.cloud.starlight.transport.channel.LongRpcChannel;
import com.baidu.cloud.starlight.transport.channel.NettyRpcChannelGroup;
import com.baidu.cloud.starlight.transport.utils.TimerHolder;
import com.baidu.cloud.thirdparty.netty.bootstrap.Bootstrap;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.util.Timeout;
import com.baidu.cloud.thirdparty.netty.util.TimerTask;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleRpcChannelGroup
extends NettyRpcChannelGroup {
    private static final Integer CHANNEL_NUM = 1;
    private RpcChannel rpcChannel;
    private AtomicBoolean inited = new AtomicBoolean(false);
    private Set<Timeout> reconnectTimeouts = new CopyOnWriteArraySet<Timeout>();

    public SingleRpcChannelGroup(URI uri, Bootstrap bootStrap) {
        super(uri, bootStrap);
    }

    @Override
    public void init() {
        if (this.inited.compareAndSet(false, true)) {
            Channel channel = this.connect();
            this.rpcChannel = new LongRpcChannel(channel, ChannelSide.CLIENT, this);
            String protocolName = this.getUri().getProtocol();
            this.rpcChannel.setAttribute("protocol", protocolName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RpcChannel getRpcChannel() throws TransportException {
        if (this.rpcChannel == null || !this.rpcChannel.isActive()) {
            SingleRpcChannelGroup singleRpcChannelGroup = this;
            synchronized (singleRpcChannelGroup) {
                LOGGER.debug("SingleChannelGroup getChannel start");
                if (this.rpcChannel == null || !this.rpcChannel.isActive()) {
                    LOGGER.info("Get RpcChannel from SingleRpcChannelGroup, the original RpcChannel is not active. Will create new, remoteAddress {}, rpcChannel {}.", (Object)this.getUri().getAddress(), (Object)this.rpcChannel);
                    if (this.rpcChannel != null) {
                        LOGGER.info("Close old rpcChannel when create new, old RpcChannel {},RemoteAddress {}", (Object)this.rpcChannel, (Object)this.getUri().getAddress());
                        new Thread(this.rpcChannel::close).start();
                    }
                    LongRpcChannel newChannel = new LongRpcChannel(this.connect(), ChannelSide.CLIENT);
                    newChannel.setAttribute("protocol", this.getUri().getProtocol());
                    this.returnRpcChannel(newChannel);
                }
            }
        }
        LocalContext.getContext("thread.classloader").set(this.rpcChannel.channel().id().asLongText(), Thread.currentThread().getContextClassLoader());
        return this.rpcChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnRpcChannel(RpcChannel rpcChannel) {
        if (rpcChannel != this.rpcChannel) {
            SingleRpcChannelGroup singleRpcChannelGroup = this;
            synchronized (singleRpcChannelGroup) {
                if (rpcChannel != this.rpcChannel) {
                    this.rpcChannel = rpcChannel;
                }
            }
        }
    }

    @Override
    public void removeRpcChannel(RpcChannel rpcChannel) {
        if (rpcChannel != this.rpcChannel) {
            return;
        }
        Timeout timeout = TimerHolder.getTimer().newTimeout((TimerTask)new ReconnectTask(this, rpcChannel), 0L, TimeUnit.MILLISECONDS);
        this.reconnectTimeouts.add(timeout);
    }

    @Override
    public int rpcChannelCount() {
        return CHANNEL_NUM;
    }

    @Override
    public void close() {
        for (Timeout timeout : this.reconnectTimeouts) {
            timeout.cancel();
        }
        if (this.rpcChannel != null) {
            this.rpcChannel.close();
        }
    }

    @Override
    public Set<RpcChannel> allRpcChannels() {
        HashSet<RpcChannel> rpcChannels = new HashSet<RpcChannel>();
        rpcChannels.add(this.rpcChannel);
        return rpcChannels;
    }

    public Set<Timeout> getReconnectTimeouts() {
        return this.reconnectTimeouts;
    }

    protected static class ReconnectTask
    implements TimerTask {
        private static final Logger LOGGER = LoggerFactory.getLogger(ReconnectTask.class);
        private final SingleRpcChannelGroup channelGroup;
        private final RpcChannel needReconChannel;

        public ReconnectTask(SingleRpcChannelGroup singleRpcChannelGroup, RpcChannel needReconChannel) {
            this.channelGroup = singleRpcChannelGroup;
            this.needReconChannel = needReconChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Timeout timeout) throws Exception {
            SingleRpcChannelGroup singleRpcChannelGroup = this.channelGroup;
            synchronized (singleRpcChannelGroup) {
                try {
                    LOGGER.debug("SingleChannelGroup reconnect start");
                    RpcChannel newChannel = this.channelGroup.getRpcChannel();
                    if (newChannel != this.needReconChannel) {
                        LOGGER.info("Reconnect rpc channel success, channel not same, not need reconnect, need connect channel {}, new channel {}, remoteAddress {}", new Object[]{this.needReconChannel, newChannel, this.channelGroup.getRpcChannel().getRemoteAddress()});
                        return;
                    }
                    LOGGER.info("Will close and reconnect channel {}, remoteAddress {}", (Object)this.needReconChannel, (Object)this.needReconChannel.getRemoteAddress());
                    new Thread(this.needReconChannel::close).start();
                    newChannel = new LongRpcChannel(this.channelGroup.connect(), ChannelSide.CLIENT, this.channelGroup);
                    this.channelGroup.returnRpcChannel(newChannel);
                    LOGGER.info("Reconnect rpc channel success, remoteAddress {}", (Object)newChannel.getRemoteAddress());
                }
                catch (TransportException e) {
                    Integer reconnectedTimes = (Integer)this.needReconChannel.getAttribute("reconnected_times");
                    if (reconnectedTimes == null) {
                        reconnectedTimes = 0;
                    }
                    if (reconnectedTimes >= Constants.MAX_RECONNECT_TIMES) {
                        LOGGER.info("Maximum number {} of connection retries reached, reconnect failed: remoteHost {}, remotePort {}", new Object[]{this.channelGroup.getUri().getHost(), this.channelGroup.getUri().getPort(), e});
                        return;
                    }
                    reconnectedTimes = reconnectedTimes + 1;
                    this.needReconChannel.setAttribute("reconnected_times", reconnectedTimes);
                    LOGGER.info("Reconnect to remote {}:{} failed, retry times {}, will retry after {}s", new Object[]{this.channelGroup.getUri().getHost(), this.channelGroup.getUri().getPort(), reconnectedTimes, Constants.RECONNECT_RETRY_INTERVAL_AFTER_FAILED});
                    Timeout timeout1 = timeout.timer().newTimeout(timeout.task(), (long)Constants.RECONNECT_RETRY_INTERVAL_AFTER_FAILED.intValue(), TimeUnit.SECONDS);
                    this.channelGroup.getReconnectTimeouts().add(timeout1);
                }
                finally {
                    this.channelGroup.getReconnectTimeouts().remove(timeout);
                }
            }
        }
    }
}

