/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.transport.netty;

import com.baidu.cloud.starlight.api.rpc.threadpool.NamedThreadFactory;
import com.baidu.cloud.thirdparty.netty.util.internal.PlatformDependent;
import com.baidu.cloud.thirdparty.springframework.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectMemoryReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectMemoryReporter.class);
    private AtomicLong directMemory;
    private ScheduledThreadPoolExecutor schedulePool;

    public DirectMemoryReporter() {
        this.init();
        this.report();
    }

    private void init() {
        try {
            Field field = ReflectionUtils.findField(PlatformDependent.class, (String)"DIRECT_MEMORY_COUNTER");
            field.setAccessible(true);
            this.directMemory = (AtomicLong)field.get(PlatformDependent.class);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Get DIRECT_MEMORY_COUNTER from PlatformDependent failed.", (Throwable)e);
            return;
        }
        this.schedulePool = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("DirectMem-"));
    }

    public void report() {
        if (this.schedulePool == null) {
            return;
        }
        this.schedulePool.scheduleAtFixedRate(() -> {
            try {
                LOGGER.info("netty_direct_memory: {}B", (Object)this.directMemory.get());
                LOGGER.info("netty_direct_memory: {}K", (Object)(this.directMemory.get() / 1024L));
            }
            catch (Throwable e) {
                LOGGER.warn("Get DIRECT_MEMORY_COUNTER from directMemory failed.", e);
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    public void close() {
        if (this.schedulePool != null) {
            this.schedulePool.shutdownNow();
        }
    }
}

