/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.transport.netty;

import com.baidu.cloud.starlight.api.exception.CodecException;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.protocol.ProtocolEncoder;
import com.baidu.cloud.starlight.api.rpc.LocalContext;
import com.baidu.cloud.starlight.api.transport.channel.ChannelAttribute;
import com.baidu.cloud.starlight.api.transport.channel.ChannelSide;
import com.baidu.cloud.starlight.api.transport.channel.RpcChannel;
import com.baidu.cloud.starlight.api.utils.LogUtils;
import com.baidu.cloud.starlight.api.utils.StringUtils;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBuf;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandler;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandlerContext;
import com.baidu.cloud.thirdparty.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class EncoderHandler
extends MessageToByteEncoder<MsgBase> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncoderHandler.class);

    protected void encode(ChannelHandlerContext channelHandlerContext, MsgBase msgBase, ByteBuf byteBuf) throws Exception {
        String protocolName;
        ChannelAttribute attribute = (ChannelAttribute)channelHandlerContext.channel().attr(RpcChannel.ATTRIBUTE_KEY).get();
        if (attribute == null) {
            throw new TransportException("Netty Channel don't have ChannelAttribute instance, Channel Illegal");
        }
        ClassLoader classLoader = (ClassLoader)LocalContext.getContext("thread.classloader").get(channelHandlerContext.channel().id().asLongText());
        if (classLoader != null && attribute.getRpcChannel().side().equals((Object)ChannelSide.CLIENT)) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else if (attribute.getRpcChannel().side().equals((Object)ChannelSide.CLIENT)) {
            LOGGER.error("Class Loader related to channel {} is null, plz check", (Object)channelHandlerContext.channel().id().asLongText());
        }
        if (msgBase == null) {
            throw new CodecException(TransportException.BODY_NULL_EXCEPTION, "Message is null, cannot encode!");
        }
        Object timeBeforeIoExec = msgBase.getNoneAdditionKv().get("before_io_thread_execute_time");
        if (timeBeforeIoExec instanceof Long) {
            LogUtils.addLogTimeAttachment(msgBase, "wait_for_io_thread_cost", System.currentTimeMillis() - (Long)timeBeforeIoExec);
        }
        if (StringUtils.isBlank(protocolName = msgBase.getProtocolName())) {
            throw new CodecException("Cannot encode the message, protocol info is null in the message");
        }
        ProtocolEncoder encoder = ExtensionLoader.getInstance(Protocol.class).getExtension(protocolName).getEncoder();
        ByteBuf encodeResult = null;
        try {
            long beforeEncodeHeaderTime = System.currentTimeMillis();
            LogUtils.addLogTimeAttachment(msgBase, "before_encode_header_time", beforeEncodeHeaderTime);
            if (msgBase instanceof Request) {
                msgBase.getAttachmentKv().put("before_encode_header_time", beforeEncodeHeaderTime);
            }
            encodeResult = encoder.encode(msgBase);
            LogUtils.addLogTimeAttachment(msgBase, "encode_header_cost", System.currentTimeMillis() - beforeEncodeHeaderTime);
            if (msgBase instanceof Response) {
                LogUtils.addLogTimeAttachment(msgBase, "end_request_time", System.currentTimeMillis());
                LogUtils.recordAccessLog(((Response)msgBase).getRequest(), (Response)msgBase);
            }
            if (msgBase instanceof Request) {
                LogUtils.addLogTimeAttachment(msgBase, "before_call_server_time", System.currentTimeMillis());
            }
            byteBuf.writeBytes(encodeResult);
            LOGGER.debug("Send msg to {}, size {}", (Object)channelHandlerContext.channel().remoteAddress(), (Object)byteBuf.readableBytes());
        }
        catch (CodecException e) {
            LOGGER.warn("Protocol encode fail, protocol: " + protocolName, (Throwable)e);
            throw e;
        }
        finally {
            if (encodeResult != null && encodeResult.refCnt() > 0) {
                encodeResult.release();
            }
        }
    }
}

