/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.transport.netty;

import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.protocol.HeartbeatTrigger;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.transport.channel.ChannelAttribute;
import com.baidu.cloud.starlight.api.transport.channel.ChannelSide;
import com.baidu.cloud.starlight.api.transport.channel.RpcChannel;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.channel.ChannelFuture;
import com.baidu.cloud.thirdparty.netty.channel.ChannelFutureListener;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandlerContext;
import com.baidu.cloud.thirdparty.netty.channel.ChannelInboundHandlerAdapter;
import com.baidu.cloud.thirdparty.netty.handler.timeout.IdleStateEvent;
import com.baidu.cloud.thirdparty.netty.util.AttributeKey;
import com.baidu.cloud.thirdparty.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatHandler.class);
    public static final AttributeKey<Integer> HEARTBEAT_FAIL_TIMES = AttributeKey.valueOf((String)"heartbeat");

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ChannelAttribute attribute = (ChannelAttribute)ctx.channel().attr(RpcChannel.ATTRIBUTE_KEY).get();
            if (attribute.getRpcChannel().side().equals((Object)ChannelSide.CLIENT)) {
                if (ctx.channel().attr(HEARTBEAT_FAIL_TIMES).get() == null) {
                    ctx.channel().attr(HEARTBEAT_FAIL_TIMES).set((Object)0);
                }
                this.triggerHeartbeat(ctx);
            } else {
                LOGGER.info("Server side, No IO operation for a long time, close the connection, remoteAddr {}", (Object)ctx.channel().remoteAddress());
                ctx.channel().close();
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    private void triggerHeartbeat(final ChannelHandlerContext context) {
        ChannelAttribute attribute = (ChannelAttribute)context.channel().attr(RpcChannel.ATTRIBUTE_KEY).get();
        if (attribute == null || attribute.getRpcChannel() == null) {
            throw new StarlightRpcException("AttributeKey<RpcChannel> value is null");
        }
        final RpcChannel rpcChannel = attribute.getRpcChannel();
        HeartbeatTrigger heartbeatTrigger = null;
        if (attribute.getChannelProtocol() != null && !attribute.getChannelProtocol().equals("unspecified")) {
            Protocol protocol = ExtensionLoader.getInstance(Protocol.class).getExtension(attribute.getChannelProtocol());
            heartbeatTrigger = protocol.getHeartbeatTrigger();
        }
        if (heartbeatTrigger != null) {
            Request heartbeatRequest = heartbeatTrigger.heartbeatRequest();
            ChannelFuture channelFuture = context.channel().writeAndFlush((Object)heartbeatRequest);
            channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (!channelFuture.isSuccess()) {
                        HeartbeatHandler.this.addHeartbeatFailTimes(context.channel());
                        LOGGER.info("Send heartbeat Ping message to remote {} failed.", (Object)rpcChannel.getRemoteAddress(), (Object)channelFuture.cause());
                    } else {
                        HeartbeatHandler.this.clearHeartbeatFailTimes(context.channel());
                    }
                }
            });
        } else {
            this.addHeartbeatFailTimes(context.channel());
        }
        if ((Integer)context.channel().attr(HEARTBEAT_FAIL_TIMES).get() >= 3) {
            try {
                rpcChannel.reconnect();
            }
            catch (Exception e) {
                LOGGER.debug("Heartbeat Reconnect Failed", (Throwable)e);
            }
        }
    }

    private void addHeartbeatFailTimes(Channel channel) {
        channel.attr(HEARTBEAT_FAIL_TIMES).set((Object)((Integer)channel.attr(HEARTBEAT_FAIL_TIMES).get() + 1));
    }

    private void clearHeartbeatFailTimes(Channel channel) {
        channel.attr(HEARTBEAT_FAIL_TIMES).set((Object)0);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ctx.channel().attr(HEARTBEAT_FAIL_TIMES).set((Object)0);
        if (!(msg instanceof MsgBase)) {
            ctx.fireChannelRead(msg);
            return;
        }
        if (!((MsgBase)msg).isHeartbeat()) {
            ctx.fireChannelRead(msg);
            return;
        }
        ChannelAttribute attribute = (ChannelAttribute)ctx.channel().attr(RpcChannel.ATTRIBUTE_KEY).get();
        if (attribute == null || attribute.getRpcChannel() == null) {
            throw new TransportException(TransportException.RPC_CHANNEL_NULL_EXCEPTION, "RpcChannel in Channel is null");
        }
        RpcChannel rpcChannel = attribute.getRpcChannel();
        if (msg instanceof Request) {
            this.handleHeartbeatRequest(rpcChannel, (Request)msg);
        }
        if (msg instanceof Response) {
            this.handleHeartbeatResponse(rpcChannel, (Response)msg);
        }
    }

    private void handleHeartbeatRequest(RpcChannel rpcChannel, Request request) {
        Protocol protocol = ExtensionLoader.getInstance(Protocol.class).getExtension(request.getProtocolName());
        if (protocol == null) {
            throw new TransportException(TransportException.HEARTBEAT_EXCEPTION, "Heartbeat request protocol is not supported");
        }
        Response response = protocol.getHeartbeatTrigger().heartbeatResponse();
        response.setId(request.getId());
        rpcChannel.send(response);
    }

    private void handleHeartbeatResponse(RpcChannel rpcChannel, Response response) {
    }
}

