/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.transport.netty;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.rpc.Processor;
import com.baidu.cloud.starlight.api.rpc.RpcContext;
import com.baidu.cloud.starlight.api.rpc.callback.RpcCallback;
import com.baidu.cloud.starlight.api.transport.ClientPeer;
import com.baidu.cloud.starlight.api.transport.PeerStatus;
import com.baidu.cloud.starlight.api.transport.channel.RpcChannel;
import com.baidu.cloud.starlight.api.transport.channel.RpcChannelGroup;
import com.baidu.cloud.starlight.transport.channel.PooledRpcChannelGroup;
import com.baidu.cloud.starlight.transport.channel.SingleRpcChannelGroup;
import com.baidu.cloud.starlight.transport.netty.DecoderHandler;
import com.baidu.cloud.starlight.transport.netty.EncoderHandler;
import com.baidu.cloud.starlight.transport.netty.HeartbeatHandler;
import com.baidu.cloud.starlight.transport.netty.RpcHandler;
import com.baidu.cloud.starlight.transport.utils.TimerHolder;
import com.baidu.cloud.thirdparty.netty.bootstrap.Bootstrap;
import com.baidu.cloud.thirdparty.netty.buffer.PooledByteBufAllocator;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandler;
import com.baidu.cloud.thirdparty.netty.channel.ChannelInitializer;
import com.baidu.cloud.thirdparty.netty.channel.ChannelOption;
import com.baidu.cloud.thirdparty.netty.channel.EventLoopGroup;
import com.baidu.cloud.thirdparty.netty.channel.epoll.Epoll;
import com.baidu.cloud.thirdparty.netty.channel.epoll.EpollChannelOption;
import com.baidu.cloud.thirdparty.netty.channel.epoll.EpollEventLoopGroup;
import com.baidu.cloud.thirdparty.netty.channel.epoll.EpollMode;
import com.baidu.cloud.thirdparty.netty.channel.epoll.EpollSocketChannel;
import com.baidu.cloud.thirdparty.netty.channel.nio.NioEventLoopGroup;
import com.baidu.cloud.thirdparty.netty.channel.socket.SocketChannel;
import com.baidu.cloud.thirdparty.netty.channel.socket.nio.NioSocketChannel;
import com.baidu.cloud.thirdparty.netty.handler.timeout.IdleStateHandler;
import com.baidu.cloud.thirdparty.netty.util.Timeout;
import com.baidu.cloud.thirdparty.netty.util.TimerTask;
import com.baidu.cloud.thirdparty.netty.util.concurrent.DefaultThreadFactory;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient
implements ClientPeer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClient.class);
    private RpcChannelGroup rpcChannelGroup;
    private Bootstrap bootstrap;
    private Processor processor;
    private static volatile EventLoopGroup eventLoopGroup;
    private URI uri;
    private volatile PeerStatus status;
    private static final Set<String> INSTANCE_SET;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyClient(URI uri) {
        if (eventLoopGroup == null) {
            NettyClient nettyClient = this;
            synchronized (nettyClient) {
                if (eventLoopGroup == null) {
                    int ioThreadNum = uri.getParameter("io_thread_num", Constants.DEFAULT_IO_THREADS_VALUE);
                    int ioRatio = uri.getParameter("netty_ioratio", 100);
                    if (Epoll.isAvailable()) {
                        eventLoopGroup = new EpollEventLoopGroup(ioThreadNum, (ThreadFactory)new DefaultThreadFactory("star-c-epoll", true));
                        ((EpollEventLoopGroup)eventLoopGroup).setIoRatio(ioRatio);
                    } else {
                        eventLoopGroup = new NioEventLoopGroup(ioThreadNum, (ThreadFactory)new DefaultThreadFactory("star-c-nio", true));
                        ((NioEventLoopGroup)eventLoopGroup).setIoRatio(ioRatio);
                    }
                }
            }
        }
        this.uri = uri;
        INSTANCE_SET.add(this.uri.getAddress());
    }

    @Override
    public RpcChannelGroup getChannelGroup() {
        return this.rpcChannelGroup;
    }

    @Override
    public void connect() {
        this.rpcChannelGroup = this.rpcChannelGroup(this.getUri().getParameter("channel_type", "long"));
        this.rpcChannelGroup.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(final Request request, RpcCallback callback) throws TransportException {
        if (this.rpcChannelGroup == null) {
            throw new TransportException("RpcChannelGroup of NettyClient is null, plz check");
        }
        final RpcChannel rpcChannel = this.rpcChannelGroup.getRpcChannel();
        try {
            int requestTimeoutMills = Constants.REQUEST_TIMEOUT_VALUE;
            if (request.getServiceConfig() != null && request.getServiceConfig().getInvokeTimeoutMills() != null && request.getServiceConfig().getInvokeTimeoutMills() > 0) {
                requestTimeoutMills = request.getServiceConfig().getInvokeTimeoutMills();
            }
            if (RpcContext.getContext().getRequestTimeoutMills() != null && RpcContext.getContext().getRequestTimeoutMills() > 0) {
                requestTimeoutMills = RpcContext.getContext().getRequestTimeoutMills();
            }
            request.getAttachmentKv().put("request_timeout", requestTimeoutMills);
            Timeout timeout = TimerHolder.getTimer().newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    RpcCallback rpcCallback = rpcChannel.removeCallback(request.getId());
                    if (rpcCallback == null) {
                        return;
                    }
                    rpcCallback.onError(StarlightRpcException.timeoutException(request, NettyClient.this.getUri().getAddress()));
                }
            }, (long)requestTimeoutMills, TimeUnit.MILLISECONDS);
            callback.addTimeout(timeout);
            rpcChannel.putCallback(request.getId(), callback);
            rpcChannel.send(request);
        }
        finally {
            this.rpcChannelGroup.returnRpcChannel(rpcChannel);
        }
    }

    @Override
    public void init() {
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(eventLoopGroup);
        if (Epoll.isAvailable()) {
            this.bootstrap.channel(EpollSocketChannel.class);
            this.bootstrap.option(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
            LOGGER.debug("NettyClient use Epoll Mode");
        } else {
            this.bootstrap.channel(NioSocketChannel.class);
            LOGGER.debug("NettyClient use Nio Mode");
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE)).option(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.getUri().getParameter("connect_timeout", Constants.CONNECT_TIMEOUT_VALUE));
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new DecoderHandler()});
                if (NettyClient.this.getUri().getParameter("connect_keepalive_enabled", false)) {
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler((long)NettyClient.this.getUri().getParameter("read_idle_timeout", 60), 0L, 0L, TimeUnit.SECONDS)}).addLast(new ChannelHandler[]{new HeartbeatHandler()});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new RpcHandler(NettyClient.this)}).addLast(new ChannelHandler[]{new EncoderHandler()});
            }
        };
        this.bootstrap.handler((ChannelHandler)initializer);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void close() {
        if (this.processor != null) {
            this.processor.close();
        }
        if (this.rpcChannelGroup != null) {
            this.rpcChannelGroup.close();
        }
        INSTANCE_SET.remove(this.uri.getAddress());
    }

    @Override
    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    private RpcChannelGroup rpcChannelGroup(String channelType) {
        if (channelType != null) {
            switch (channelType) {
                case "long": {
                    return new SingleRpcChannelGroup(this.getUri(), this.bootstrap);
                }
                case "pool": {
                    return new PooledRpcChannelGroup(this.getUri(), this.bootstrap);
                }
            }
            throw new StarlightRpcException("RpcChannelGroup type {" + channelType + "} is illegal: not support.");
        }
        throw new StarlightRpcException("RpcChannelGroup type is null");
    }

    @Override
    public PeerStatus status() {
        return this.status;
    }

    @Override
    public void gracefullyShutdown(long quietPeriod, long timeout) {
        try {
            this.updateStatus(new PeerStatus(PeerStatus.Status.SHUTTING_DOWN, System.currentTimeMillis()));
            if (timeout > 0L) {
                long shutdownTimeoutTime = System.currentTimeMillis() + timeout * 1000L;
                while (true) {
                    int unfinishedCallbackNum = 0;
                    for (RpcChannel rpcChannel : this.rpcChannelGroup.allRpcChannels()) {
                        if (rpcChannel == null) continue;
                        unfinishedCallbackNum += rpcChannel.allCallbacks().size();
                    }
                    if (this.getProcessor().allWaitTaskCount().equals(0) && unfinishedCallbackNum == 0) {
                        LOGGER.info("NettyClient has processed all requests, shutdown. RemoteAddr {}", (Object)this.getUri().getAddress());
                        break;
                    }
                    if (System.currentTimeMillis() >= shutdownTimeoutTime) {
                        LOGGER.info("NettyClient reach the maximum timeout time, force shutdown. RemoteAddr {}.Number of unfinished task {}, Number of unfinished request {}. Will response timeout", new Object[]{this.getUri().getAddress(), this.getProcessor().allWaitTaskCount(), unfinishedCallbackNum});
                        for (RpcChannel rpcChannel : this.rpcChannelGroup.allRpcChannels()) {
                            if (rpcChannel.allCallbacks() == null || rpcChannel.allCallbacks().size() <= 0) continue;
                            for (RpcCallback rpcCallback : rpcChannel.allCallbacks().values()) {
                                rpcCallback.onError(StarlightRpcException.timeoutException(rpcCallback.getRequest(), this.getUri().getAddress()));
                            }
                            rpcChannel.allCallbacks().clear();
                        }
                        break;
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.close();
            this.updateStatus(new PeerStatus(PeerStatus.Status.SHUTDOWN, System.currentTimeMillis()));
        }
        catch (Exception e) {
            LOGGER.error("An exception occur when NettyClient shutdownGracefully.", (Throwable)e);
        }
    }

    @Override
    public synchronized void updateStatus(PeerStatus newStatus) {
        if (this.status == null) {
            LOGGER.debug("Update {} status from {} to {}", new Object[]{this.getUri().getAddress(), this.status, newStatus});
            this.status = newStatus;
            return;
        }
        if (PeerStatus.Status.SHUTTING_DOWN.equals((Object)this.status.getStatus()) && PeerStatus.Status.OUTLIER.equals((Object)newStatus.getStatus())) {
            LOGGER.warn("Forbidden to change status of ClientPeer {} from SHUTTINGDOWN to OUTLIER", (Object)this.getUri().getAddress());
            return;
        }
        if (PeerStatus.Status.SHUTDOWN.equals((Object)this.status.getStatus()) && PeerStatus.Status.OUTLIER.equals((Object)newStatus.getStatus())) {
            LOGGER.warn("Forbidden to change status of ClientPeer {} from SHUTDOWN to OUTLIER", (Object)this.getUri().getAddress());
            return;
        }
        if (PeerStatus.Status.OUTLIER.equals((Object)newStatus.getStatus()) && PeerStatus.Status.OUTLIER.equals((Object)this.status.getStatus())) {
            LOGGER.warn("Forbidden to change status of ClientPeer {} from OUTLIER {} to OUTLIER {}", new Object[]{this.getUri().getAddress(), this.status.getStatusRecordTime(), newStatus.getStatusRecordTime()});
            return;
        }
        LOGGER.debug("Update {} status from {} to {}", new Object[]{this.getUri().getAddress(), this.status, newStatus});
        this.status = newStatus;
    }

    static {
        INSTANCE_SET = new CopyOnWriteArraySet<String>();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (eventLoopGroup == null) {
                return;
            }
            if (INSTANCE_SET.isEmpty()) {
                LOGGER.info("All the instance of NettyClient is closed, will shutdown eventloop gracefully");
                eventLoopGroup.shutdownGracefully();
            }
            long beginShutdownTime = System.currentTimeMillis();
            while (true) {
                if (INSTANCE_SET.isEmpty()) {
                    LOGGER.info("All the instance of NettyClient is closed, will shutdown eventloop gracefully");
                    eventLoopGroup.shutdownGracefully();
                    break;
                }
                if (System.currentTimeMillis() - beginShutdownTime > 120000L) {
                    LOGGER.info("Reach the max shutdown time, will shutdown enventloop gracefully");
                    eventLoopGroup.shutdownGracefully();
                    break;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }));
    }
}

