/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.transport.netty;

import com.baidu.cloud.starlight.api.common.Constants;
import com.baidu.cloud.starlight.api.common.URI;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.RpcResponse;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.rpc.Processor;
import com.baidu.cloud.starlight.api.transport.PeerStatus;
import com.baidu.cloud.starlight.api.transport.ServerPeer;
import com.baidu.cloud.starlight.api.transport.channel.RpcChannel;
import com.baidu.cloud.starlight.api.utils.EnvUtils;
import com.baidu.cloud.starlight.transport.netty.DecoderHandler;
import com.baidu.cloud.starlight.transport.netty.DirectMemoryReporter;
import com.baidu.cloud.starlight.transport.netty.EncoderHandler;
import com.baidu.cloud.starlight.transport.netty.HeartbeatHandler;
import com.baidu.cloud.starlight.transport.netty.RpcHandler;
import com.baidu.cloud.thirdparty.netty.bootstrap.ServerBootstrap;
import com.baidu.cloud.thirdparty.netty.buffer.PooledByteBufAllocator;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.channel.ChannelFuture;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandler;
import com.baidu.cloud.thirdparty.netty.channel.ChannelInitializer;
import com.baidu.cloud.thirdparty.netty.channel.ChannelOption;
import com.baidu.cloud.thirdparty.netty.channel.EventLoopGroup;
import com.baidu.cloud.thirdparty.netty.channel.SingleThreadEventLoop;
import com.baidu.cloud.thirdparty.netty.channel.epoll.Epoll;
import com.baidu.cloud.thirdparty.netty.channel.epoll.EpollChannelOption;
import com.baidu.cloud.thirdparty.netty.channel.epoll.EpollEventLoopGroup;
import com.baidu.cloud.thirdparty.netty.channel.epoll.EpollMode;
import com.baidu.cloud.thirdparty.netty.channel.epoll.EpollServerSocketChannel;
import com.baidu.cloud.thirdparty.netty.channel.nio.NioEventLoopGroup;
import com.baidu.cloud.thirdparty.netty.channel.socket.SocketChannel;
import com.baidu.cloud.thirdparty.netty.channel.socket.nio.NioServerSocketChannel;
import com.baidu.cloud.thirdparty.netty.handler.timeout.IdleStateHandler;
import com.baidu.cloud.thirdparty.netty.util.concurrent.DefaultThreadFactory;
import com.baidu.cloud.thirdparty.netty.util.concurrent.EventExecutor;
import com.baidu.cloud.thirdparty.netty.util.concurrent.GlobalEventExecutor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements ServerPeer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServer.class);
    private Processor processor;
    private URI uri;
    private ServerBootstrap bootstrap;
    private EventLoopGroup parentGroup;
    private EventLoopGroup childGroup;
    private Channel serverChannel;
    private Map<String, RpcChannel> rpcChannels;
    private volatile PeerStatus status;
    private DirectMemoryReporter reporter;

    public NettyServer(URI uri) {
        this.uri = uri;
        this.rpcChannels = new ConcurrentHashMap<String, RpcChannel>();
    }

    @Override
    public void init() {
        this.bootstrap = new ServerBootstrap();
        int acceptThreadNum = this.uri.getParameter("accept_thread_num", Constants.DEFAULT_ACCEPTOR_THREAD_VALUE);
        int ioThreadNum = this.uri.getParameter("io_thread_num", Constants.DEFAULT_IO_THREADS_VALUE);
        int ioRatio = this.uri.getParameter("netty_ioratio", 100);
        if (Epoll.isAvailable()) {
            this.parentGroup = new EpollEventLoopGroup(acceptThreadNum, (ThreadFactory)new DefaultThreadFactory("star-s-epoll-accept", false));
            this.childGroup = new EpollEventLoopGroup(ioThreadNum, (ThreadFactory)new DefaultThreadFactory("star-s-epoll", false));
            ((EpollEventLoopGroup)this.parentGroup).setIoRatio(ioRatio);
            ((EpollEventLoopGroup)this.childGroup).setIoRatio(ioRatio);
            this.bootstrap.channel(EpollServerSocketChannel.class);
            this.bootstrap.option(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
            this.bootstrap.childOption(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
            LOGGER.info("NettyServer use epoll mode.");
        } else {
            this.parentGroup = new NioEventLoopGroup(acceptThreadNum, (ThreadFactory)new DefaultThreadFactory("star-s-nio-accept", false));
            this.childGroup = new NioEventLoopGroup(ioThreadNum, (ThreadFactory)new DefaultThreadFactory("star-s-nio", false));
            ((NioEventLoopGroup)this.parentGroup).setIoRatio(ioRatio);
            ((NioEventLoopGroup)this.childGroup).setIoRatio(ioRatio);
            this.bootstrap.channel(NioServerSocketChannel.class);
            LOGGER.info("NettyServer use Nio mode.");
        }
        this.bootstrap.group(this.parentGroup, this.childGroup);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE);
        this.bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE);
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)Constants.SO_BACKLOG);
        this.bootstrap.childOption(ChannelOption.SO_LINGER, (Object)Constants.SO_LINGER);
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Constants.SO_SNDBUF);
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Constants.SO_REVBUF);
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new DecoderHandler()});
                if (NettyServer.this.getUri().getParameter("connect_keepalive_enabled", false)) {
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, (long)NettyServer.this.getUri().getParameter("all_idle_timeout", 210), TimeUnit.SECONDS)}).addLast(new ChannelHandler[]{new HeartbeatHandler()});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new RpcHandler(NettyServer.this)}).addLast(new ChannelHandler[]{new EncoderHandler()});
            }
        };
        this.bootstrap.childHandler((ChannelHandler)initializer);
    }

    @Override
    public void bind() {
        ChannelFuture channelFuture = this.bootstrap.bind(this.getUri().getHost(), this.getUri().getPort());
        channelFuture.syncUninterruptibly();
        if (!channelFuture.isSuccess()) {
            throw new TransportException(TransportException.BIND_EXCEPTION, "Server bind to ip {" + this.getUri().getHost() + "}, port {" + this.getUri().getPort() + "} failed", channelFuture.cause());
        }
        LOGGER.info("Starlight server bind to ip {} port {}", (Object)this.getUri().getHost(), (Object)this.getUri().getPort());
        this.serverChannel = channelFuture.channel();
        if (!EnvUtils.isJarvisOnline()) {
            this.reporter = new DirectMemoryReporter();
        }
        this.updateStatus(new PeerStatus(PeerStatus.Status.ACTIVE, System.currentTimeMillis()));
    }

    @Override
    public boolean isBound() {
        return this.serverChannel.isOpen();
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void close() {
        try {
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            if (this.processor != null) {
                this.processor.close();
            }
            if (this.reporter != null) {
                this.reporter.close();
            }
        }
        finally {
            if (this.parentGroup != null) {
                this.parentGroup.shutdownGracefully();
            }
            if (this.childGroup != null) {
                this.childGroup.shutdownGracefully();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gracefullyShutdown(long quietPeriod, long timeout) {
        LOGGER.info("Shutdown starlight server gracefully start");
        try {
            LOGGER.info("Notify server shutting down to clients begin");
            long startTime = System.currentTimeMillis();
            for (Map.Entry<String, RpcChannel> entry : this.rpcChannels.entrySet()) {
                try {
                    RpcResponse shuttingDownEvent = this.shuttingDownEvent("stargate");
                    Protocol protocol = ExtensionLoader.getInstance(Protocol.class).getExtension("stargate");
                    protocol.getEncoder().encodeBody(shuttingDownEvent);
                    entry.getValue().send(shuttingDownEvent);
                    LOGGER.info("Notify server shutting to {}", (Object)entry.getValue().channel().remoteAddress());
                }
                catch (TransportException e) {
                    LOGGER.warn("Notify client SHUTTING_DOWN failed, remoteAddress: {}", (Object)entry.getKey(), (Object)e);
                }
            }
            LOGGER.info("Notify server shutting down end, cost {} clients {}", (Object)(System.currentTimeMillis() - startTime), (Object)this.rpcChannels.size());
            long shutdownTimeoutTime = System.currentTimeMillis() + timeout * 1000L;
            if (quietPeriod > 0L) {
                LOGGER.info("Wait for quiet period pass {}s", (Object)quietPeriod);
                try {
                    TimeUnit.SECONDS.sleep(quietPeriod);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.updateStatus(new PeerStatus(PeerStatus.Status.SHUTTING_DOWN, System.currentTimeMillis()));
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            if (timeout > 0L) {
                while (true) {
                    if (this.pendingTaskNum().equals(0) && this.getProcessor().allWaitTaskCount().equals(0)) {
                        LOGGER.info("NettyServer has processed all requests, gracefully shutdown.");
                        break;
                    }
                    if (System.currentTimeMillis() >= shutdownTimeoutTime) {
                        LOGGER.info("NettyServer reach the maximum timeout time, force shutdown. Number of unfinished request {}", (Object)this.getProcessor().allWaitTaskCount());
                        break;
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.processor != null) {
                this.processor.close();
            }
            this.updateStatus(new PeerStatus(PeerStatus.Status.SHUTDOWN, System.currentTimeMillis()));
        }
        catch (Throwable e) {
            LOGGER.warn("Shutdown starlight server gracefully failed, cause by: ", e);
        }
        finally {
            if (this.parentGroup != null) {
                this.parentGroup.shutdownGracefully();
            }
            if (this.childGroup != null) {
                this.childGroup.shutdownGracefully();
            }
        }
        LOGGER.info("Shutdown starlight server gracefully end");
    }

    @Override
    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public Map<String, RpcChannel> rpcChannels() {
        return this.rpcChannels;
    }

    @Override
    public PeerStatus status() {
        return this.status;
    }

    @Override
    public void updateStatus(PeerStatus status) {
        this.status = status;
    }

    private Integer pendingTaskNum() {
        Integer pendingTaskNum = 0;
        try {
            for (EventExecutor eventExecutor : this.parentGroup) {
                if (!(eventExecutor instanceof SingleThreadEventLoop)) continue;
                pendingTaskNum = pendingTaskNum + ((SingleThreadEventLoop)eventExecutor).pendingTasks();
            }
            LOGGER.debug("Parent event loop group pending task num {}", (Object)pendingTaskNum);
            for (EventExecutor eventExecutor : this.childGroup) {
                if (!(eventExecutor instanceof SingleThreadEventLoop)) continue;
                pendingTaskNum = pendingTaskNum + ((SingleThreadEventLoop)eventExecutor).pendingTasks();
            }
            LOGGER.debug("Parent and child event loop group pending task num {}", (Object)pendingTaskNum);
            pendingTaskNum = pendingTaskNum + GlobalEventExecutor.INSTANCE.pendingTasks();
            LOGGER.debug("Parent and child and global event loop group pending task num {}", (Object)pendingTaskNum);
        }
        catch (Throwable e) {
            LOGGER.warn("Calculate netty pending task count failed, caused by ", e);
        }
        LOGGER.info("Netty pending tasks num is {}", (Object)pendingTaskNum);
        return pendingTaskNum;
    }
}

