/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.starlight.transport.netty;

import com.baidu.cloud.starlight.api.exception.StarlightRpcException;
import com.baidu.cloud.starlight.api.exception.TransportException;
import com.baidu.cloud.starlight.api.extension.ExtensionLoader;
import com.baidu.cloud.starlight.api.model.MsgBase;
import com.baidu.cloud.starlight.api.model.Request;
import com.baidu.cloud.starlight.api.model.Response;
import com.baidu.cloud.starlight.api.model.RpcResponse;
import com.baidu.cloud.starlight.api.model.ShuttingDownEvent;
import com.baidu.cloud.starlight.api.protocol.Protocol;
import com.baidu.cloud.starlight.api.rpc.LocalContext;
import com.baidu.cloud.starlight.api.transport.ClientPeer;
import com.baidu.cloud.starlight.api.transport.Peer;
import com.baidu.cloud.starlight.api.transport.PeerStatus;
import com.baidu.cloud.starlight.api.transport.ServerPeer;
import com.baidu.cloud.starlight.api.transport.channel.ChannelAttribute;
import com.baidu.cloud.starlight.api.transport.channel.ChannelSide;
import com.baidu.cloud.starlight.api.transport.channel.RpcChannel;
import com.baidu.cloud.starlight.api.transport.channel.ThreadLocalChannelContext;
import com.baidu.cloud.starlight.transport.channel.LongRpcChannel;
import com.baidu.cloud.starlight.transport.netty.HeartbeatHandler;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandler;
import com.baidu.cloud.thirdparty.netty.channel.ChannelHandlerContext;
import com.baidu.cloud.thirdparty.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class RpcHandler
extends SimpleChannelInboundHandler<MsgBase> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcHandler.class);
    private final Peer peer;

    public RpcHandler(Peer peer) {
        this.peer = peer;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        ThreadLocalChannelContext.getContext().setChannel(channel);
        ChannelAttribute attribute = (ChannelAttribute)channel.attr(RpcChannel.ATTRIBUTE_KEY).get();
        if (attribute == null && this.peer instanceof ServerPeer) {
            LongRpcChannel rpcChannel = new LongRpcChannel(channel, ChannelSide.SERVER);
            ((ServerPeer)this.peer).rpcChannels().put(this.toAddressString((InetSocketAddress)channel.remoteAddress()), rpcChannel);
        }
        super.channelActive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, MsgBase msg) throws Exception {
        RpcResponse response;
        if (msg == null) {
            throw new StarlightRpcException(StarlightRpcException.MSG_NULL_EXCEPTION, "The Message read from socket is null");
        }
        ChannelAttribute attribute = (ChannelAttribute)ctx.channel().attr(RpcChannel.ATTRIBUTE_KEY).get();
        if (attribute == null || attribute.getRpcChannel() == null) {
            throw new TransportException(TransportException.RPC_CHANNEL_NULL_EXCEPTION, "RpcChannel in Channel is null");
        }
        RpcChannel rpcChannel = attribute.getRpcChannel();
        rpcChannel.receive(msg);
        if (msg instanceof Response && this.peer instanceof ClientPeer && (response = (RpcResponse)msg).getResult() instanceof ShuttingDownEvent) {
            LOGGER.info("Client receive server shutting down event, will close the related client, remoteAddress {}", (Object)rpcChannel.getRemoteAddress());
            this.peer.updateStatus(new PeerStatus(PeerStatus.Status.SHUTTING_DOWN, System.currentTimeMillis()));
            return;
        }
        if ((this.peer.status().getStatus().equals((Object)PeerStatus.Status.SHUTTING_DOWN) || this.peer.status().getStatus().equals((Object)PeerStatus.Status.SHUTDOWN)) && msg instanceof Request && this.peer instanceof ServerPeer) {
            LOGGER.warn("The server was shutting down and received a request, status {}, remoteAddress {}, request {}", new Object[]{this.peer.status(), ctx.channel().remoteAddress(), msg});
            RpcResponse shuttingDownResponse = this.peer.shuttingDownResponse((Request)msg);
            Protocol protocol = ExtensionLoader.getInstance(Protocol.class).getExtension("stargate");
            protocol.getEncoder().encodeBody(shuttingDownResponse);
            ctx.channel().writeAndFlush((Object)shuttingDownResponse);
            return;
        }
        this.peer.getProcessor().process(msg, rpcChannel);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        if (this.peer instanceof ServerPeer) {
            LOGGER.info("Server Channel is closing, channelId {}, remoteAddress {}", (Object)channel.id().asLongText(), (Object)channel.remoteAddress());
            ((ServerPeer)this.peer).rpcChannels().remove(this.toAddressString((InetSocketAddress)channel.remoteAddress()));
            return;
        }
        boolean isHeartbeatFail = false;
        if (channel.attr(HeartbeatHandler.HEARTBEAT_FAIL_TIMES).get() != null && (Integer)channel.attr(HeartbeatHandler.HEARTBEAT_FAIL_TIMES).get() >= 3) {
            isHeartbeatFail = true;
        }
        if (isHeartbeatFail) {
            LOGGER.info("Client Channel is closing because heartbeat fail, will reconnect. ChannelId {}, remoteAddress {}", (Object)channel.id().asLongText(), (Object)channel.remoteAddress());
            return;
        }
        ChannelAttribute attribute = (ChannelAttribute)channel.attr(RpcChannel.ATTRIBUTE_KEY).get();
        if (attribute != null && attribute.getRpcChannel() != null) {
            LOGGER.info("Client Channel is being closing may cause by starlight call close | network unhealth | server closing. ChannelId {}, remoteAddress {}", (Object)channel.id().asLongText(), (Object)channel.remoteAddress());
        }
        LocalContext.getContext("thread.classloader").set(channel.id().asLongText(), null);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.debug("NettyHandlers unhandled exception appear, please pay attention. cause by {}", (Object)cause.getMessage());
    }

    private String toAddressString(InetSocketAddress address) {
        return address.getAddress().getHostAddress() + ":" + address.getPort();
    }
}

