/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.http.impl;

import com.baidu.dev2.thirdparty.http.HttpResponse;
import com.baidu.dev2.thirdparty.http.HttpResponseFactory;
import com.baidu.dev2.thirdparty.http.ProtocolVersion;
import com.baidu.dev2.thirdparty.http.ReasonPhraseCatalog;
import com.baidu.dev2.thirdparty.http.StatusLine;
import com.baidu.dev2.thirdparty.http.annotation.Contract;
import com.baidu.dev2.thirdparty.http.annotation.ThreadingBehavior;
import com.baidu.dev2.thirdparty.http.impl.EnglishReasonPhraseCatalog;
import com.baidu.dev2.thirdparty.http.message.BasicHttpResponse;
import com.baidu.dev2.thirdparty.http.message.BasicStatusLine;
import com.baidu.dev2.thirdparty.http.protocol.HttpContext;
import com.baidu.dev2.thirdparty.http.util.Args;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

