/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.http.impl.client;

import com.baidu.dev2.thirdparty.http.HttpConnection;
import com.baidu.dev2.thirdparty.http.annotation.Contract;
import com.baidu.dev2.thirdparty.http.annotation.ThreadingBehavior;
import com.baidu.dev2.thirdparty.http.auth.AuthScheme;
import com.baidu.dev2.thirdparty.http.auth.AuthState;
import com.baidu.dev2.thirdparty.http.auth.Credentials;
import com.baidu.dev2.thirdparty.http.client.UserTokenHandler;
import com.baidu.dev2.thirdparty.http.client.protocol.HttpClientContext;
import com.baidu.dev2.thirdparty.http.conn.ManagedHttpClientConnection;
import com.baidu.dev2.thirdparty.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpConnection conn;
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Principal userPrincipal = null;
        AuthState targetAuthState = clientContext.getTargetAuthState();
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = clientContext.getProxyAuthState();
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = clientContext.getConnection()).isOpen() && conn instanceof ManagedHttpClientConnection && (sslsession = ((ManagedHttpClientConnection)conn).getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

