/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.http.impl.execchain;

import com.baidu.dev2.thirdparty.commons.logging.Log;
import com.baidu.dev2.thirdparty.commons.logging.LogFactory;
import com.baidu.dev2.thirdparty.http.Header;
import com.baidu.dev2.thirdparty.http.HttpException;
import com.baidu.dev2.thirdparty.http.annotation.Contract;
import com.baidu.dev2.thirdparty.http.annotation.ThreadingBehavior;
import com.baidu.dev2.thirdparty.http.client.ServiceUnavailableRetryStrategy;
import com.baidu.dev2.thirdparty.http.client.methods.CloseableHttpResponse;
import com.baidu.dev2.thirdparty.http.client.methods.HttpExecutionAware;
import com.baidu.dev2.thirdparty.http.client.methods.HttpRequestWrapper;
import com.baidu.dev2.thirdparty.http.client.protocol.HttpClientContext;
import com.baidu.dev2.thirdparty.http.conn.routing.HttpRoute;
import com.baidu.dev2.thirdparty.http.impl.execchain.ClientExecChain;
import com.baidu.dev2.thirdparty.http.impl.execchain.RequestEntityProxy;
import com.baidu.dev2.thirdparty.http.util.Args;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context) && RequestEntityProxy.isRepeatable(request)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

