/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.http.protocol;

import com.baidu.dev2.thirdparty.http.HttpEntityEnclosingRequest;
import com.baidu.dev2.thirdparty.http.HttpException;
import com.baidu.dev2.thirdparty.http.HttpRequest;
import com.baidu.dev2.thirdparty.http.HttpRequestInterceptor;
import com.baidu.dev2.thirdparty.http.annotation.Contract;
import com.baidu.dev2.thirdparty.http.annotation.ThreadingBehavior;
import com.baidu.dev2.thirdparty.http.protocol.HttpContext;
import com.baidu.dev2.thirdparty.http.protocol.HttpDateGenerator;
import com.baidu.dev2.thirdparty.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

