/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.http.protocol;

import com.baidu.dev2.thirdparty.http.HttpEntity;
import com.baidu.dev2.thirdparty.http.HttpEntityEnclosingRequest;
import com.baidu.dev2.thirdparty.http.HttpException;
import com.baidu.dev2.thirdparty.http.HttpRequest;
import com.baidu.dev2.thirdparty.http.HttpRequestInterceptor;
import com.baidu.dev2.thirdparty.http.HttpVersion;
import com.baidu.dev2.thirdparty.http.ProtocolVersion;
import com.baidu.dev2.thirdparty.http.annotation.Contract;
import com.baidu.dev2.thirdparty.http.annotation.ThreadingBehavior;
import com.baidu.dev2.thirdparty.http.protocol.HttpContext;
import com.baidu.dev2.thirdparty.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

