/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.dev2.thirdparty.jackson.module.jaxb.ser;

import com.baidu.dev2.thirdparty.jackson.core.JsonGenerator;
import com.baidu.dev2.thirdparty.jackson.core.JsonProcessingException;
import com.baidu.dev2.thirdparty.jackson.databind.JavaType;
import com.baidu.dev2.thirdparty.jackson.databind.JsonMappingException;
import com.baidu.dev2.thirdparty.jackson.databind.JsonNode;
import com.baidu.dev2.thirdparty.jackson.databind.SerializerProvider;
import com.baidu.dev2.thirdparty.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.baidu.dev2.thirdparty.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.baidu.dev2.thirdparty.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.baidu.dev2.thirdparty.jackson.databind.node.ObjectNode;
import com.baidu.dev2.thirdparty.jackson.databind.ser.std.StdSerializer;
import com.baidu.dev2.thirdparty.javax.activation.DataHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;

public class DataHandlerJsonSerializer
extends StdSerializer<DataHandler> {
    private static final long serialVersionUID = 1L;

    public DataHandlerJsonSerializer() {
        super(DataHandler.class);
    }

    @Override
    public void serialize(DataHandler value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        InputStream in = value.getInputStream();
        int len = in.read(buffer);
        while (len > 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        jgen.writeBinary(out.toByteArray());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
            v2.itemsFormat(JsonFormatTypes.STRING);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("string");
        o.set("items", itemSchema);
        return o;
    }
}

