/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.fetcher.impl;

import com.baidu.disconf.client.fetcher.FetcherMgr;
import com.baidu.disconf.core.common.constants.Constants;
import com.baidu.disconf.core.common.json.ValueVo;
import com.baidu.disconf.core.common.restful.RestfulMgr;
import com.baidu.disconf.core.common.restful.core.RemoteUrl;
import com.baidu.disconf.core.common.utils.OsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetcherMgrImpl
implements FetcherMgr {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FetcherMgrImpl.class);
    private int retryTime = 3;
    private int retrySleepSeconds = 5;
    private boolean enableLocalDownloadDirInClassPath = true;
    private String localDownloadDir;
    private String localDownloadDirTemp;
    private List<String> hostList = new ArrayList<String>();
    private RestfulMgr restfulMgr = null;

    public FetcherMgrImpl(RestfulMgr restfulMgr, int retryTime, int retrySleepSeconds, boolean enableLocalDownloadDirInClassPath, String localDownloadDir, String localDownloadDirTemp, List<String> hostList) {
        this.restfulMgr = restfulMgr;
        this.retrySleepSeconds = retrySleepSeconds;
        this.retryTime = retryTime;
        this.enableLocalDownloadDirInClassPath = enableLocalDownloadDirInClassPath;
        this.localDownloadDir = localDownloadDir;
        this.localDownloadDirTemp = localDownloadDirTemp;
        OsUtil.makeDirs((String)this.localDownloadDir);
        this.hostList = hostList;
    }

    @Override
    public String getValueFromServer(String url) throws Exception {
        RemoteUrl remoteUrl = new RemoteUrl(url, this.hostList);
        ValueVo confItemVo = (ValueVo)this.restfulMgr.getJsonData(ValueVo.class, remoteUrl, this.retryTime, this.retrySleepSeconds);
        LOGGER.debug("remote server return: " + confItemVo.toString());
        if (confItemVo.getStatus().equals(Constants.NOTOK)) {
            throw new Exception("status is not ok.");
        }
        return confItemVo.getValue();
    }

    @Override
    public String downloadFileFromServer(String url, String fileName, String targetFileDir) throws Exception {
        String localDir = this.getLocalDownloadDirPath();
        RemoteUrl remoteUrl = new RemoteUrl(url, this.hostList);
        return this.restfulMgr.downloadFromServer(remoteUrl, fileName, localDir, this.localDownloadDirTemp, targetFileDir, this.enableLocalDownloadDirInClassPath, this.retryTime, this.retrySleepSeconds);
    }

    private String getLocalDownloadDirPath() throws Exception {
        String localUrl = this.localDownloadDir;
        if (!new File(localUrl).exists()) {
            new File(localUrl).mkdirs();
        }
        return localUrl;
    }

    @Override
    public void release() {
        this.restfulMgr.close();
    }
}

