/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.watch.inner;

import com.baidu.disconf.client.core.processor.DisconfCoreProcessor;
import com.baidu.disconf.client.watch.inner.DisconfSysUpdateCallback;
import com.baidu.disconf.core.common.constants.DisConfigTypeEnum;
import com.baidu.disconf.core.common.zookeeper.ZookeeperMgr;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeWatcher
implements Watcher {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NodeWatcher.class);
    private String monitorPath = "";
    private String keyName = "";
    private DisConfigTypeEnum disConfigTypeEnum;
    private DisconfSysUpdateCallback disconfSysUpdateCallback;
    private boolean debug;
    private DisconfCoreProcessor disconfCoreMgr;

    public NodeWatcher(DisconfCoreProcessor disconfCoreMgr, String monitorPath, String keyName, DisConfigTypeEnum disConfigTypeEnum, DisconfSysUpdateCallback disconfSysUpdateCallback, boolean debug) {
        this.debug = debug;
        this.disconfCoreMgr = disconfCoreMgr;
        this.monitorPath = monitorPath;
        this.keyName = keyName;
        this.disConfigTypeEnum = disConfigTypeEnum;
        this.disconfSysUpdateCallback = disconfSysUpdateCallback;
    }

    public void monitorMaster() {
        Stat stat = new Stat();
        try {
            ZookeeperMgr.getInstance().read(this.monitorPath, (Watcher)this, stat);
        }
        catch (InterruptedException e) {
            LOGGER.info(e.toString());
        }
        catch (KeeperException e) {
            LOGGER.error("cannot monitor " + this.monitorPath, (Throwable)e);
        }
        LOGGER.debug("monitor path: (" + this.monitorPath + "," + this.keyName + "," + this.disConfigTypeEnum.getModelName() + ") has been added!");
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
            try {
                LOGGER.info("============GOT UPDATE EVENT " + event.toString() + ": (" + this.monitorPath + "," + this.keyName + "," + this.disConfigTypeEnum.getModelName() + ")======================");
                this.callback();
            }
            catch (Exception e) {
                LOGGER.error("monitor node exception. " + this.monitorPath, (Throwable)e);
            }
        }
        if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
            if (!this.debug) {
                LOGGER.warn("============GOT Disconnected EVENT " + event.toString() + ": (" + this.monitorPath + "," + this.keyName + "," + this.disConfigTypeEnum.getModelName() + ")======================");
            } else {
                LOGGER.debug("============DEBUG MODE: GOT Disconnected EVENT " + event.toString() + ": (" + this.monitorPath + "," + this.keyName + "," + this.disConfigTypeEnum.getModelName() + ")======================");
            }
        }
        if (event.getState() == Watcher.Event.KeeperState.Expired) {
            if (!this.debug) {
                LOGGER.error("============GOT Expired  " + event.toString() + ": (" + this.monitorPath + "," + this.keyName + "," + this.disConfigTypeEnum.getModelName() + ")======================");
                ZookeeperMgr.getInstance().reconnect();
                this.callback();
            } else {
                LOGGER.debug("============DEBUG MODE: GOT Expired  " + event.toString() + ": (" + this.monitorPath + "," + "" + this.keyName + "," + this.disConfigTypeEnum.getModelName() + ")======================");
            }
        }
    }

    private void callback() {
        try {
            try {
                this.disconfSysUpdateCallback.reload(this.disconfCoreMgr, this.disConfigTypeEnum, this.keyName);
            }
            catch (Exception e) {
                LOGGER.error(e.toString(), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("monitor node exception. " + this.monitorPath, (Throwable)e);
        }
    }
}

