/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.auth;

import com.baidu.hugegraph.api.auth.AuthAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.auth.Access;
import com.baidu.hugegraph.structure.constant.HugeType;
import java.util.LinkedHashMap;
import java.util.List;

public class AccessAPI
extends AuthAPI {
    public AccessAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.ACCESS.string();
    }

    public Access create(Access access) {
        RestResult result = this.client.post(this.path(), access);
        return (Access)result.readObject(Access.class);
    }

    public Access get(Object id) {
        RestResult result = this.client.get(this.path(), AccessAPI.formatRelationId(id));
        return (Access)result.readObject(Access.class);
    }

    public List<Access> list(Object group, Object target, int limit) {
        AccessAPI.checkLimit(limit, "Limit");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("limit", limit);
        params.put("group", AccessAPI.formatEntityId(group));
        params.put("target", AccessAPI.formatEntityId(target));
        RestResult result = this.client.get(this.path(), params);
        return result.readList(this.type(), Access.class);
    }

    public Access update(Access access) {
        String id = AccessAPI.formatRelationId(access.id());
        RestResult result = this.client.put(this.path(), id, access);
        return (Access)result.readObject(Access.class);
    }

    public void delete(Object id) {
        this.client.delete(this.path(), AccessAPI.formatRelationId(id));
    }
}

