/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.auth;

import com.baidu.hugegraph.api.auth.AuthAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.auth.Belong;
import com.baidu.hugegraph.structure.constant.HugeType;
import java.util.LinkedHashMap;
import java.util.List;

public class BelongAPI
extends AuthAPI {
    public BelongAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.BELONG.string();
    }

    public Belong create(Belong belong) {
        RestResult result = this.client.post(this.path(), belong);
        return (Belong)result.readObject(Belong.class);
    }

    public Belong get(Object id) {
        RestResult result = this.client.get(this.path(), BelongAPI.formatRelationId(id));
        return (Belong)result.readObject(Belong.class);
    }

    public List<Belong> list(Object user, Object group, int limit) {
        BelongAPI.checkLimit(limit, "Limit");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("limit", limit);
        params.put("user", BelongAPI.formatEntityId(user));
        params.put("group", BelongAPI.formatEntityId(group));
        RestResult result = this.client.get(this.path(), params);
        return result.readList(this.type(), Belong.class);
    }

    public Belong update(Belong belong) {
        String id = BelongAPI.formatRelationId(belong.id());
        RestResult result = this.client.put(this.path(), id, belong);
        return (Belong)result.readObject(Belong.class);
    }

    public void delete(Object id) {
        this.client.delete(this.path(), BelongAPI.formatRelationId(id));
    }
}

