/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.auth;

import com.baidu.hugegraph.api.auth.AuthAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.auth.Group;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class GroupAPI
extends AuthAPI {
    public GroupAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.GROUP.string();
    }

    public Group create(Group group) {
        RestResult result = this.client.post(this.path(), group);
        return (Group)result.readObject(Group.class);
    }

    public Group get(Object id) {
        RestResult result = this.client.get(this.path(), GroupAPI.formatEntityId(id));
        return (Group)result.readObject(Group.class);
    }

    public List<Group> list(int limit) {
        GroupAPI.checkLimit(limit, "Limit");
        ImmutableMap params = ImmutableMap.of((Object)"limit", (Object)limit);
        RestResult result = this.client.get(this.path(), (Map)params);
        return result.readList(this.type(), Group.class);
    }

    public Group update(Group group) {
        String id = GroupAPI.formatEntityId(group.id());
        RestResult result = this.client.put(this.path(), id, group);
        return (Group)result.readObject(Group.class);
    }

    public void delete(Object id) {
        this.client.delete(this.path(), GroupAPI.formatEntityId(id));
    }
}

