/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.auth;

import com.baidu.hugegraph.api.auth.AuthAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.auth.User;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class UserAPI
extends AuthAPI {
    public UserAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.USER.string();
    }

    public User create(User user) {
        RestResult result = this.client.post(this.path(), user);
        return (User)result.readObject(User.class);
    }

    public User get(Object id) {
        RestResult result = this.client.get(this.path(), UserAPI.formatEntityId(id));
        return (User)result.readObject(User.class);
    }

    public User.UserRole getUserRole(Object id) {
        String idEncoded = RestClient.encode((String)UserAPI.formatEntityId(id));
        String path = String.join((CharSequence)"/", this.path(), idEncoded, "role");
        RestResult result = this.client.get(path);
        return (User.UserRole)result.readObject(User.UserRole.class);
    }

    public List<User> list(int limit) {
        UserAPI.checkLimit(limit, "Limit");
        ImmutableMap params = ImmutableMap.of((Object)"limit", (Object)limit);
        RestResult result = this.client.get(this.path(), (Map)params);
        return result.readList(this.type(), User.class);
    }

    public User update(User user) {
        String id = UserAPI.formatEntityId(user.id());
        RestResult result = this.client.put(this.path(), id, user);
        return (User)result.readObject(User.class);
    }

    public void delete(Object id) {
        this.client.delete(this.path(), UserAPI.formatEntityId(id));
    }
}

