/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.job;

import com.baidu.hugegraph.api.job.JobAPI;
import com.baidu.hugegraph.api.task.TaskAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.SchemaElement;
import com.baidu.hugegraph.structure.schema.EdgeLabel;
import com.baidu.hugegraph.structure.schema.IndexLabel;
import com.baidu.hugegraph.structure.schema.VertexLabel;
import com.baidu.hugegraph.util.E;
import java.util.Map;

public class RebuildAPI
extends JobAPI {
    private static final String JOB_TYPE = "rebuild";

    public RebuildAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String jobType() {
        return JOB_TYPE;
    }

    public long rebuild(VertexLabel vertexLabel) {
        return this.rebuildIndex(vertexLabel);
    }

    public long rebuild(EdgeLabel edgeLabel) {
        return this.rebuildIndex(edgeLabel);
    }

    public long rebuild(IndexLabel indexLabel) {
        return this.rebuildIndex(indexLabel);
    }

    private long rebuildIndex(SchemaElement element) {
        E.checkArgument((element instanceof VertexLabel || element instanceof EdgeLabel || element instanceof IndexLabel ? 1 : 0) != 0, (String)"Only VertexLabel, EdgeLabel and IndexLabel support rebuild, but got '%s'", (Object[])new Object[]{element});
        String path = String.join((CharSequence)"/", this.path(), element.type());
        RestResult result = this.client.put(path, element.name(), element);
        Map task = (Map)result.readObject(Map.class);
        return TaskAPI.parseTaskId(task);
    }
}

