/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.schema;

import com.baidu.hugegraph.api.schema.SchemaElementAPI;
import com.baidu.hugegraph.api.task.TaskAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.SchemaElement;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.baidu.hugegraph.structure.schema.SchemaLabel;
import com.baidu.hugegraph.structure.schema.VertexLabel;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class VertexLabelAPI
extends SchemaElementAPI {
    public VertexLabelAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.VERTEX_LABEL.string();
    }

    public VertexLabel create(VertexLabel vertexLabel) {
        Object vl = this.checkCreateOrUpdate(vertexLabel);
        RestResult result = this.client.post(this.path(), vl);
        return (VertexLabel)result.readObject(VertexLabel.class);
    }

    public VertexLabel append(VertexLabel vertexLabel) {
        String id = vertexLabel.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"append");
        Object vl = this.checkCreateOrUpdate(vertexLabel);
        RestResult result = this.client.put(this.path(), id, vl, (Map)params);
        return (VertexLabel)result.readObject(VertexLabel.class);
    }

    public VertexLabel eliminate(VertexLabel vertexLabel) {
        String id = vertexLabel.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"eliminate");
        Object vl = this.checkCreateOrUpdate(vertexLabel);
        RestResult result = this.client.put(this.path(), id, vl, (Map)params);
        return (VertexLabel)result.readObject(VertexLabel.class);
    }

    public VertexLabel get(String name) {
        RestResult result = this.client.get(this.path(), name);
        return (VertexLabel)result.readObject(VertexLabel.class);
    }

    public List<VertexLabel> list() {
        RestResult result = this.client.get(this.path());
        return result.readList(this.type(), VertexLabel.class);
    }

    public List<VertexLabel> list(List<String> names) {
        this.client.checkApiVersion("0.48", "getting schema by names");
        E.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (String)"The vertex label names can't be null or empty", (Object[])new Object[0]);
        ImmutableMap params = ImmutableMap.of((Object)"names", names);
        RestResult result = this.client.get(this.path(), (Map)params);
        return result.readList(this.type(), VertexLabel.class);
    }

    public long delete(String name) {
        RestResult result = this.client.delete(this.path(), name);
        Map task = (Map)result.readObject(Map.class);
        return TaskAPI.parseTaskId(task);
    }

    @Override
    protected Object checkCreateOrUpdate(SchemaElement schemaElement) {
        VertexLabel vertexLabel = (VertexLabel)schemaElement;
        if (vertexLabel.idStrategy().isCustomizeUuid()) {
            this.client.checkApiVersion("0.46", "customize UUID strategy");
        }
        SchemaLabel vl = vertexLabel;
        if (this.client.apiVersionLt("0.54")) {
            E.checkArgument((vertexLabel.ttl() == 0L && vertexLabel.ttlStartTime() == null ? 1 : 0) != 0, (String)"Not support ttl until api version 0.54", (Object[])new Object[0]);
            vl = vertexLabel.switchV53();
        }
        return vl;
    }
}

