/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.graph.Path;
import java.util.LinkedHashMap;
import java.util.List;

public class AllShortestPathsAPI
extends TraversersAPI {
    public AllShortestPathsAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "allshortestpaths";
    }

    public List<Path> get(Object sourceId, Object targetId, Direction direction, String label, int maxDepth, long degree, long skipDegree, long capacity) {
        this.client.checkApiVersion("0.51", "all shortest path");
        String source = GraphAPI.formatVertexId(sourceId, false);
        String target = GraphAPI.formatVertexId(targetId, false);
        AllShortestPathsAPI.checkPositive(maxDepth, "Max depth of shortest path");
        AllShortestPathsAPI.checkDegree(degree);
        AllShortestPathsAPI.checkCapacity(capacity);
        AllShortestPathsAPI.checkSkipDegree(skipDegree, degree, capacity);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("target", target);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", maxDepth);
        params.put("max_degree", degree);
        params.put("skip_degree", skipDegree);
        params.put("capacity", capacity);
        RestResult result = this.client.get(this.path(), params);
        return result.readList("paths", Path.class);
    }
}

