/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.graph.Edge;
import com.baidu.hugegraph.structure.graph.Edges;
import com.baidu.hugegraph.structure.graph.Shard;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EdgesAPI
extends TraversersAPI {
    public EdgesAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "edges";
    }

    public List<Edge> list(List<String> ids) {
        E.checkArgument((ids != null && !ids.isEmpty() ? 1 : 0) != 0, (String)"Ids can't be null or empty", (Object[])new Object[0]);
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("ids", ids);
        RestResult result = this.client.get(this.path(), params);
        return result.readList(this.type(), Edge.class);
    }

    public List<Shard> shards(long splitSize) {
        String path = String.join((CharSequence)"/", this.path(), "shards");
        ImmutableMap params = ImmutableMap.of((Object)"split_size", (Object)splitSize);
        RestResult result = this.client.get(path, (Map)params);
        return result.readList("shards", Shard.class);
    }

    public Edges scan(Shard shard, String page, long pageLimit) {
        E.checkArgument((shard != null ? 1 : 0) != 0, (String)"Shard can't be null", (Object[])new Object[0]);
        String path = String.join((CharSequence)"/", this.path(), "scan");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("start", shard.start());
        params.put("end", shard.end());
        params.put("page", page);
        params.put("page_limit", pageLimit);
        RestResult result = this.client.get(path, params);
        return (Edges)result.readObject(Edges.class);
    }
}

